/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.ecr.DefaultECRClientBuilder;
import software.amazon.awssdk.services.ecr.ECRClientBuilder;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecr.model.BatchGetImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchGetImageResponse;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DeleteLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.ECRException;
import software.amazon.awssdk.services.ecr.model.EmptyUploadException;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerRequest;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.InvalidLayerException;
import software.amazon.awssdk.services.ecr.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecr.model.InvalidParameterException;
import software.amazon.awssdk.services.ecr.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.LayerInaccessibleException;
import software.amazon.awssdk.services.ecr.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecr.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyNotFoundException;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewInProgressException;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewNotFoundException;
import software.amazon.awssdk.services.ecr.model.LimitExceededException;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;
import software.amazon.awssdk.services.ecr.model.PutImageRequest;
import software.amazon.awssdk.services.ecr.model.PutImageResponse;
import software.amazon.awssdk.services.ecr.model.PutLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.PutLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecr.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecr.model.ServerException;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecr.model.UploadNotFoundException;
import software.amazon.awssdk.services.ecr.paginators.DescribeImagesPaginator;
import software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPaginator;
import software.amazon.awssdk.services.ecr.paginators.ListImagesPaginator;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface ECRClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "ecr";

    public static ECRClient create() {
        return (ECRClient)ECRClient.builder().build();
    }

    public static ECRClientBuilder builder() {
        return new DefaultECRClientBuilder();
    }

    default public BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) throws RepositoryNotFoundException, InvalidParameterException, ServerException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(Consumer<BatchCheckLayerAvailabilityRequest.Builder> batchCheckLayerAvailabilityRequest) throws RepositoryNotFoundException, InvalidParameterException, ServerException, SdkServiceException, SdkClientException, ECRException {
        return this.batchCheckLayerAvailability((BatchCheckLayerAvailabilityRequest)((Object)((BatchCheckLayerAvailabilityRequest.Builder)BatchCheckLayerAvailabilityRequest.builder().apply(batchCheckLayerAvailabilityRequest)).build()));
    }

    default public BatchDeleteImageResponse batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public BatchDeleteImageResponse batchDeleteImage(Consumer<BatchDeleteImageRequest.Builder> batchDeleteImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.batchDeleteImage((BatchDeleteImageRequest)((Object)((BatchDeleteImageRequest.Builder)BatchDeleteImageRequest.builder().apply(batchDeleteImageRequest)).build()));
    }

    default public BatchGetImageResponse batchGetImage(BatchGetImageRequest batchGetImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public BatchGetImageResponse batchGetImage(Consumer<BatchGetImageRequest.Builder> batchGetImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.batchGetImage((BatchGetImageRequest)((Object)((BatchGetImageRequest.Builder)BatchGetImageRequest.builder().apply(batchGetImageRequest)).build()));
    }

    default public CompleteLayerUploadResponse completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException, InvalidLayerException, LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public CompleteLayerUploadResponse completeLayerUpload(Consumer<CompleteLayerUploadRequest.Builder> completeLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException, InvalidLayerException, LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException, SdkServiceException, SdkClientException, ECRException {
        return this.completeLayerUpload((CompleteLayerUploadRequest)((Object)((CompleteLayerUploadRequest.Builder)CompleteLayerUploadRequest.builder().apply(completeLayerUploadRequest)).build()));
    }

    default public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryAlreadyExistsException, LimitExceededException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public CreateRepositoryResponse createRepository(Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryAlreadyExistsException, LimitExceededException, SdkServiceException, SdkClientException, ECRException {
        return this.createRepository((CreateRepositoryRequest)((Object)((CreateRepositoryRequest.Builder)CreateRepositoryRequest.builder().apply(createRepositoryRequest)).build()));
    }

    default public DeleteLifecyclePolicyResponse deleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLifecyclePolicyResponse deleteLifecyclePolicy(Consumer<DeleteLifecyclePolicyRequest.Builder> deleteLifecyclePolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.deleteLifecyclePolicy((DeleteLifecyclePolicyRequest)((Object)((DeleteLifecyclePolicyRequest.Builder)DeleteLifecyclePolicyRequest.builder().apply(deleteLifecyclePolicyRequest)).build()));
    }

    default public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DeleteRepositoryResponse deleteRepository(Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException, SdkServiceException, SdkClientException, ECRException {
        return this.deleteRepository((DeleteRepositoryRequest)((Object)((DeleteRepositoryRequest.Builder)DeleteRepositoryRequest.builder().apply(deleteRepositoryRequest)).build()));
    }

    default public DeleteRepositoryPolicyResponse deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DeleteRepositoryPolicyResponse deleteRepositoryPolicy(Consumer<DeleteRepositoryPolicyRequest.Builder> deleteRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.deleteRepositoryPolicy((DeleteRepositoryPolicyRequest)((Object)((DeleteRepositoryPolicyRequest.Builder)DeleteRepositoryPolicyRequest.builder().apply(deleteRepositoryPolicyRequest)).build()));
    }

    default public DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DescribeImagesResponse describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.describeImages((DescribeImagesRequest)((Object)((DescribeImagesRequest.Builder)DescribeImagesRequest.builder().apply(describeImagesRequest)).build()));
    }

    default public DescribeImagesPaginator describeImagesIterable(DescribeImagesRequest describeImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DescribeRepositoriesResponse describeRepositories() throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.describeRepositories((DescribeRepositoriesRequest)((Object)DescribeRepositoriesRequest.builder().build()));
    }

    default public DescribeRepositoriesResponse describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DescribeRepositoriesResponse describeRepositories(Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.describeRepositories((DescribeRepositoriesRequest)((Object)((DescribeRepositoriesRequest.Builder)DescribeRepositoriesRequest.builder().apply(describeRepositoriesRequest)).build()));
    }

    default public DescribeRepositoriesPaginator describeRepositoriesIterable() throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.describeRepositoriesIterable((DescribeRepositoriesRequest)((Object)DescribeRepositoriesRequest.builder().build()));
    }

    default public DescribeRepositoriesPaginator describeRepositoriesIterable(DescribeRepositoriesRequest describeRepositoriesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetAuthorizationTokenResponse getAuthorizationToken() throws ServerException, InvalidParameterException, SdkServiceException, SdkClientException, ECRException {
        return this.getAuthorizationToken((GetAuthorizationTokenRequest)((Object)GetAuthorizationTokenRequest.builder().build()));
    }

    default public GetAuthorizationTokenResponse getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) throws ServerException, InvalidParameterException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetAuthorizationTokenResponse getAuthorizationToken(Consumer<GetAuthorizationTokenRequest.Builder> getAuthorizationTokenRequest) throws ServerException, InvalidParameterException, SdkServiceException, SdkClientException, ECRException {
        return this.getAuthorizationToken((GetAuthorizationTokenRequest)((Object)((GetAuthorizationTokenRequest.Builder)GetAuthorizationTokenRequest.builder().apply(getAuthorizationTokenRequest)).build()));
    }

    default public GetDownloadUrlForLayerResponse getDownloadUrlForLayer(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) throws ServerException, InvalidParameterException, LayersNotFoundException, LayerInaccessibleException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetDownloadUrlForLayerResponse getDownloadUrlForLayer(Consumer<GetDownloadUrlForLayerRequest.Builder> getDownloadUrlForLayerRequest) throws ServerException, InvalidParameterException, LayersNotFoundException, LayerInaccessibleException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.getDownloadUrlForLayer((GetDownloadUrlForLayerRequest)((Object)((GetDownloadUrlForLayerRequest.Builder)GetDownloadUrlForLayerRequest.builder().apply(getDownloadUrlForLayerRequest)).build()));
    }

    default public GetLifecyclePolicyResponse getLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetLifecyclePolicyResponse getLifecyclePolicy(Consumer<GetLifecyclePolicyRequest.Builder> getLifecyclePolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.getLifecyclePolicy((GetLifecyclePolicyRequest)((Object)((GetLifecyclePolicyRequest.Builder)GetLifecyclePolicyRequest.builder().apply(getLifecyclePolicyRequest)).build()));
    }

    default public GetLifecyclePolicyPreviewResponse getLifecyclePolicyPreview(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyPreviewNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetLifecyclePolicyPreviewResponse getLifecyclePolicyPreview(Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyPreviewNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.getLifecyclePolicyPreview((GetLifecyclePolicyPreviewRequest)((Object)((GetLifecyclePolicyPreviewRequest.Builder)GetLifecyclePolicyPreviewRequest.builder().apply(getLifecyclePolicyPreviewRequest)).build()));
    }

    default public GetRepositoryPolicyResponse getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetRepositoryPolicyResponse getRepositoryPolicy(Consumer<GetRepositoryPolicyRequest.Builder> getRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.getRepositoryPolicy((GetRepositoryPolicyRequest)((Object)((GetRepositoryPolicyRequest.Builder)GetRepositoryPolicyRequest.builder().apply(getRepositoryPolicyRequest)).build()));
    }

    default public InitiateLayerUploadResponse initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public InitiateLayerUploadResponse initiateLayerUpload(Consumer<InitiateLayerUploadRequest.Builder> initiateLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.initiateLayerUpload((InitiateLayerUploadRequest)((Object)((InitiateLayerUploadRequest.Builder)InitiateLayerUploadRequest.builder().apply(initiateLayerUploadRequest)).build()));
    }

    default public ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public ListImagesResponse listImages(Consumer<ListImagesRequest.Builder> listImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.listImages((ListImagesRequest)((Object)((ListImagesRequest.Builder)ListImagesRequest.builder().apply(listImagesRequest)).build()));
    }

    default public ListImagesPaginator listImagesIterable(ListImagesRequest listImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public PutImageResponse putImage(PutImageRequest putImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException, LimitExceededException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public PutImageResponse putImage(Consumer<PutImageRequest.Builder> putImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException, LimitExceededException, SdkServiceException, SdkClientException, ECRException {
        return this.putImage((PutImageRequest)((Object)((PutImageRequest.Builder)PutImageRequest.builder().apply(putImageRequest)).build()));
    }

    default public PutLifecyclePolicyResponse putLifecyclePolicy(PutLifecyclePolicyRequest putLifecyclePolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public PutLifecyclePolicyResponse putLifecyclePolicy(Consumer<PutLifecyclePolicyRequest.Builder> putLifecyclePolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.putLifecyclePolicy((PutLifecyclePolicyRequest)((Object)((PutLifecyclePolicyRequest.Builder)PutLifecyclePolicyRequest.builder().apply(putLifecyclePolicyRequest)).build()));
    }

    default public SetRepositoryPolicyResponse setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public SetRepositoryPolicyResponse setRepositoryPolicy(Consumer<SetRepositoryPolicyRequest.Builder> setRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkServiceException, SdkClientException, ECRException {
        return this.setRepositoryPolicy((SetRepositoryPolicyRequest)((Object)((SetRepositoryPolicyRequest.Builder)SetRepositoryPolicyRequest.builder().apply(setRepositoryPolicyRequest)).build()));
    }

    default public StartLifecyclePolicyPreviewResponse startLifecyclePolicyPreview(StartLifecyclePolicyPreviewRequest startLifecyclePolicyPreviewRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException, LifecyclePolicyPreviewInProgressException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public StartLifecyclePolicyPreviewResponse startLifecyclePolicyPreview(Consumer<StartLifecyclePolicyPreviewRequest.Builder> startLifecyclePolicyPreviewRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException, LifecyclePolicyPreviewInProgressException, SdkServiceException, SdkClientException, ECRException {
        return this.startLifecyclePolicyPreview((StartLifecyclePolicyPreviewRequest)((Object)((StartLifecyclePolicyPreviewRequest.Builder)StartLifecyclePolicyPreviewRequest.builder().apply(startLifecyclePolicyPreviewRequest)).build()));
    }

    default public UploadLayerPartResponse uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) throws ServerException, InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException, UploadNotFoundException, LimitExceededException, SdkServiceException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public UploadLayerPartResponse uploadLayerPart(Consumer<UploadLayerPartRequest.Builder> uploadLayerPartRequest) throws ServerException, InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException, UploadNotFoundException, LimitExceededException, SdkServiceException, SdkClientException, ECRException {
        return this.uploadLayerPart((UploadLayerPartRequest)((Object)((UploadLayerPartRequest.Builder)UploadLayerPartRequest.builder().apply(uploadLayerPartRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

