/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.BatchGetImageRequest;

@SdkInternalApi
public class BatchGetImageRequestModelMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").build();
    private static final MarshallingInfo<List> IMAGEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageIds").build();
    private static final MarshallingInfo<List> ACCEPTEDMEDIATYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acceptedMediaTypes").build();
    private static final BatchGetImageRequestModelMarshaller INSTANCE = new BatchGetImageRequestModelMarshaller();

    public static BatchGetImageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetImageRequest batchGetImageRequest, ProtocolMarshaller protocolMarshaller) {
        if (batchGetImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)batchGetImageRequest.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)batchGetImageRequest.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall(batchGetImageRequest.imageIds(), IMAGEIDS_BINDING);
            protocolMarshaller.marshall(batchGetImageRequest.acceptedMediaTypes(), ACCEPTEDMEDIATYPES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

