/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartLifecyclePolicyPreviewResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, StartLifecyclePolicyPreviewResponse> {
    private final String registryId;
    private final String repositoryName;
    private final String lifecyclePolicyText;
    private final String status;

    private StartLifecyclePolicyPreviewResponse(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.status = builder.status;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String lifecyclePolicyText() {
        return this.lifecyclePolicyText;
    }

    public LifecyclePolicyPreviewStatus status() {
        return LifecyclePolicyPreviewStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLifecyclePolicyPreviewResponse)) {
            return false;
        }
        StartLifecyclePolicyPreviewResponse other = (StartLifecyclePolicyPreviewResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.lifecyclePolicyText(), other.lifecyclePolicyText()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.lifecyclePolicyText() != null) {
            sb.append("LifecyclePolicyText: ").append(this.lifecyclePolicyText()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "lifecyclePolicyText": {
                return Optional.of(clazz.cast(this.lifecyclePolicyText()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String lifecyclePolicyText;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLifecyclePolicyPreviewResponse model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.lifecyclePolicyText(model.lifecyclePolicyText);
            this.status(model.status);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getLifecyclePolicyText() {
            return this.lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyPreviewStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public StartLifecyclePolicyPreviewResponse build() {
            return new StartLifecyclePolicyPreviewResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartLifecyclePolicyPreviewResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder lifecyclePolicyText(String var1);

        public Builder status(String var1);

        public Builder status(LifecyclePolicyPreviewStatus var1);
    }
}

