/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteRepositoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteRepositoryRequest> {
    private final String registryId;
    private final String repositoryName;
    private final Boolean force;

    private DeleteRepositoryRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.force = builder.force;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public Boolean force() {
        return this.force;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRepositoryRequest)) {
            return false;
        }
        DeleteRepositoryRequest other = (DeleteRepositoryRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.force(), other.force());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.force() != null) {
            sb.append("Force: ").append(this.force()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "force": {
                return Optional.of(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRepositoryRequest model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.force(model.force);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public DeleteRepositoryRequest build() {
            return new DeleteRepositoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteRepositoryRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder force(Boolean var1);
    }
}

