/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.LayerFailureCode;
import software.amazon.awssdk.services.ecr.transform.LayerFailureMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LayerFailure
implements StructuredPojo,
ToCopyableBuilder<Builder, LayerFailure> {
    private final String layerDigest;
    private final String failureCode;
    private final String failureReason;

    private LayerFailure(BuilderImpl builder) {
        this.layerDigest = builder.layerDigest;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    public String layerDigest() {
        return this.layerDigest;
    }

    public LayerFailureCode failureCode() {
        return LayerFailureCode.fromValue(this.failureCode);
    }

    public String failureCodeString() {
        return this.failureCode;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.layerDigest() == null ? 0 : this.layerDigest().hashCode());
        hashCode = 31 * hashCode + (this.failureCodeString() == null ? 0 : this.failureCodeString().hashCode());
        hashCode = 31 * hashCode + (this.failureReason() == null ? 0 : this.failureReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerFailure)) {
            return false;
        }
        LayerFailure other = (LayerFailure)obj;
        if (other.layerDigest() == null ^ this.layerDigest() == null) {
            return false;
        }
        if (other.layerDigest() != null && !other.layerDigest().equals(this.layerDigest())) {
            return false;
        }
        if (other.failureCodeString() == null ^ this.failureCodeString() == null) {
            return false;
        }
        if (other.failureCodeString() != null && !other.failureCodeString().equals(this.failureCodeString())) {
            return false;
        }
        if (other.failureReason() == null ^ this.failureReason() == null) {
            return false;
        }
        return other.failureReason() == null || other.failureReason().equals(this.failureReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.layerDigest() != null) {
            sb.append("LayerDigest: ").append(this.layerDigest()).append(",");
        }
        if (this.failureCodeString() != null) {
            sb.append("FailureCode: ").append(this.failureCodeString()).append(",");
        }
        if (this.failureReason() != null) {
            sb.append("FailureReason: ").append(this.failureReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layerDigest": {
                return Optional.of(clazz.cast(this.layerDigest()));
            }
            case "failureCode": {
                return Optional.of(clazz.cast(this.failureCodeString()));
            }
            case "failureReason": {
                return Optional.of(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerFailureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerDigest;
        private String failureCode;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerFailure model) {
            this.layerDigest(model.layerDigest);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(LayerFailureCode failureCode) {
            this.failureCode(failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public LayerFailure build() {
            return new LayerFailure(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LayerFailure> {
        public Builder layerDigest(String var1);

        public Builder failureCode(String var1);

        public Builder failureCode(LayerFailureCode var1);

        public Builder failureReason(String var1);
    }
}

