/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.transform.ImageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Image
implements StructuredPojo,
ToCopyableBuilder<Builder, Image> {
    private final String registryId;
    private final String repositoryName;
    private final ImageIdentifier imageId;
    private final String imageManifest;

    private Image(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.imageManifest = builder.imageManifest;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public ImageIdentifier imageId() {
        return this.imageId;
    }

    public String imageManifest() {
        return this.imageManifest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.imageManifest() == null ? 0 : this.imageManifest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.imageManifest() == null ^ this.imageManifest() == null) {
            return false;
        }
        return other.imageManifest() == null || other.imageManifest().equals(this.imageManifest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.imageManifest() != null) {
            sb.append("ImageManifest: ").append(this.imageManifest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "imageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "imageManifest": {
                return Optional.of(clazz.cast(this.imageManifest()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private ImageIdentifier imageId;
        private String imageManifest;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageId(model.imageId);
            this.imageManifest(model.imageManifest);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        public final String getImageManifest() {
            return this.imageManifest;
        }

        @Override
        public final Builder imageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
            return this;
        }

        public final void setImageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
        }

        public Image build() {
            return new Image(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Image> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageId(ImageIdentifier var1);

        public Builder imageManifest(String var1);
    }
}

