/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDownloadUrlForLayerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDownloadUrlForLayerResponse> {
    private final String downloadUrl;
    private final String layerDigest;

    private GetDownloadUrlForLayerResponse(BuilderImpl builder) {
        this.downloadUrl = builder.downloadUrl;
        this.layerDigest = builder.layerDigest;
    }

    public String downloadUrl() {
        return this.downloadUrl;
    }

    public String layerDigest() {
        return this.layerDigest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.downloadUrl() == null ? 0 : this.downloadUrl().hashCode());
        hashCode = 31 * hashCode + (this.layerDigest() == null ? 0 : this.layerDigest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDownloadUrlForLayerResponse)) {
            return false;
        }
        GetDownloadUrlForLayerResponse other = (GetDownloadUrlForLayerResponse)((Object)obj);
        if (other.downloadUrl() == null ^ this.downloadUrl() == null) {
            return false;
        }
        if (other.downloadUrl() != null && !other.downloadUrl().equals(this.downloadUrl())) {
            return false;
        }
        if (other.layerDigest() == null ^ this.layerDigest() == null) {
            return false;
        }
        return other.layerDigest() == null || other.layerDigest().equals(this.layerDigest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.downloadUrl() != null) {
            sb.append("DownloadUrl: ").append(this.downloadUrl()).append(",");
        }
        if (this.layerDigest() != null) {
            sb.append("LayerDigest: ").append(this.layerDigest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "downloadUrl": {
                return Optional.of(clazz.cast(this.downloadUrl()));
            }
            case "layerDigest": {
                return Optional.of(clazz.cast(this.layerDigest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String downloadUrl;
        private String layerDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDownloadUrlForLayerResponse model) {
            this.downloadUrl(model.downloadUrl);
            this.layerDigest(model.layerDigest);
        }

        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        public GetDownloadUrlForLayerResponse build() {
            return new GetDownloadUrlForLayerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDownloadUrlForLayerResponse> {
        public Builder downloadUrl(String var1);

        public Builder layerDigest(String var1);
    }
}

