/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.Image;
import software.amazon.awssdk.services.ecr.model.ImageFailure;
import software.amazon.awssdk.services.ecr.model.ImageFailureListCopier;
import software.amazon.awssdk.services.ecr.model.ImageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetImageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetImageResponse> {
    private final List<Image> images;
    private final List<ImageFailure> failures;

    private BatchGetImageResponse(BuilderImpl builder) {
        this.images = builder.images;
        this.failures = builder.failures;
    }

    public List<Image> images() {
        return this.images;
    }

    public List<ImageFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.images() == null ? 0 : this.images().hashCode());
        hashCode = 31 * hashCode + (this.failures() == null ? 0 : this.failures().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageResponse)) {
            return false;
        }
        BatchGetImageResponse other = (BatchGetImageResponse)((Object)obj);
        if (other.images() == null ^ this.images() == null) {
            return false;
        }
        if (other.images() != null && !other.images().equals(this.images())) {
            return false;
        }
        if (other.failures() == null ^ this.failures() == null) {
            return false;
        }
        return other.failures() == null || other.failures().equals(this.failures());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.images() != null) {
            sb.append("Images: ").append(this.images()).append(",");
        }
        if (this.failures() != null) {
            sb.append("Failures: ").append(this.failures()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "images": {
                return Optional.of(clazz.cast(this.images()));
            }
            case "failures": {
                return Optional.of(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Image> images;
        private List<ImageFailure> failures;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetImageResponse model) {
            this.images(model.images);
            this.failures(model.failures);
        }

        public final Collection<Image.Builder> getImages() {
            return this.images != null ? (Collection)this.images.stream().map(Image::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        public final Collection<ImageFailure.Builder> getFailures() {
            return this.failures != null ? (Collection)this.failures.stream().map(ImageFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ImageFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        public final void setFailures(Collection<ImageFailure.BuilderImpl> failures) {
            this.failures = ImageFailureListCopier.copyFromBuilder(failures);
        }

        public BatchGetImageResponse build() {
            return new BatchGetImageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetImageResponse> {
        public Builder images(Collection<Image> var1);

        public Builder images(Image ... var1);

        public Builder failures(Collection<ImageFailure> var1);

        public Builder failures(ImageFailure ... var1);
    }
}

