/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.transform.AuthorizationDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AuthorizationData
implements StructuredPojo,
ToCopyableBuilder<Builder, AuthorizationData> {
    private final String authorizationToken;
    private final Instant expiresAt;
    private final String proxyEndpoint;

    private AuthorizationData(BuilderImpl builder) {
        this.authorizationToken = builder.authorizationToken;
        this.expiresAt = builder.expiresAt;
        this.proxyEndpoint = builder.proxyEndpoint;
    }

    public String authorizationToken() {
        return this.authorizationToken;
    }

    public Instant expiresAt() {
        return this.expiresAt;
    }

    public String proxyEndpoint() {
        return this.proxyEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authorizationToken() == null ? 0 : this.authorizationToken().hashCode());
        hashCode = 31 * hashCode + (this.expiresAt() == null ? 0 : this.expiresAt().hashCode());
        hashCode = 31 * hashCode + (this.proxyEndpoint() == null ? 0 : this.proxyEndpoint().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationData)) {
            return false;
        }
        AuthorizationData other = (AuthorizationData)obj;
        if (other.authorizationToken() == null ^ this.authorizationToken() == null) {
            return false;
        }
        if (other.authorizationToken() != null && !other.authorizationToken().equals(this.authorizationToken())) {
            return false;
        }
        if (other.expiresAt() == null ^ this.expiresAt() == null) {
            return false;
        }
        if (other.expiresAt() != null && !other.expiresAt().equals(this.expiresAt())) {
            return false;
        }
        if (other.proxyEndpoint() == null ^ this.proxyEndpoint() == null) {
            return false;
        }
        return other.proxyEndpoint() == null || other.proxyEndpoint().equals(this.proxyEndpoint());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authorizationToken() != null) {
            sb.append("AuthorizationToken: ").append(this.authorizationToken()).append(",");
        }
        if (this.expiresAt() != null) {
            sb.append("ExpiresAt: ").append(this.expiresAt()).append(",");
        }
        if (this.proxyEndpoint() != null) {
            sb.append("ProxyEndpoint: ").append(this.proxyEndpoint()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationToken": {
                return Optional.of(clazz.cast(this.authorizationToken()));
            }
            case "expiresAt": {
                return Optional.of(clazz.cast(this.expiresAt()));
            }
            case "proxyEndpoint": {
                return Optional.of(clazz.cast(this.proxyEndpoint()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthorizationDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationToken;
        private Instant expiresAt;
        private String proxyEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationData model) {
            this.authorizationToken(model.authorizationToken);
            this.expiresAt(model.expiresAt);
            this.proxyEndpoint(model.proxyEndpoint);
        }

        public final String getAuthorizationToken() {
            return this.authorizationToken;
        }

        @Override
        public final Builder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        public final void setAuthorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        public final String getProxyEndpoint() {
            return this.proxyEndpoint;
        }

        @Override
        public final Builder proxyEndpoint(String proxyEndpoint) {
            this.proxyEndpoint = proxyEndpoint;
            return this;
        }

        public final void setProxyEndpoint(String proxyEndpoint) {
            this.proxyEndpoint = proxyEndpoint;
        }

        public AuthorizationData build() {
            return new AuthorizationData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuthorizationData> {
        public Builder authorizationToken(String var1);

        public Builder expiresAt(Instant var1);

        public Builder proxyEndpoint(String var1);
    }
}

