/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr;

import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.ecr.DefaultECRClientBuilder;
import software.amazon.awssdk.services.ecr.ECRClientBuilder;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecr.model.BatchGetImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchGetImageResponse;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.ECRException;
import software.amazon.awssdk.services.ecr.model.EmptyUploadException;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerRequest;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerResponse;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.InvalidLayerException;
import software.amazon.awssdk.services.ecr.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecr.model.InvalidParameterException;
import software.amazon.awssdk.services.ecr.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.LayerInaccessibleException;
import software.amazon.awssdk.services.ecr.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecr.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecr.model.LimitExceededException;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;
import software.amazon.awssdk.services.ecr.model.PutImageRequest;
import software.amazon.awssdk.services.ecr.model.PutImageResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecr.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecr.model.ServerException;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecr.model.UploadNotFoundException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface ECRClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "ecr";

    public static ECRClient create() {
        return (ECRClient)ECRClient.builder().build();
    }

    public static ECRClientBuilder builder() {
        return new DefaultECRClientBuilder();
    }

    default public BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) throws RepositoryNotFoundException, InvalidParameterException, ServerException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public BatchDeleteImageResponse batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public BatchGetImageResponse batchGetImage(BatchGetImageRequest batchGetImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public CompleteLayerUploadResponse completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException, InvalidLayerException, LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryAlreadyExistsException, LimitExceededException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DeleteRepositoryPolicyResponse deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public DescribeRepositoriesResponse describeRepositories() throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        return this.describeRepositories((DescribeRepositoriesRequest)((Object)DescribeRepositoriesRequest.builder().build()));
    }

    default public DescribeRepositoriesResponse describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetAuthorizationTokenResponse getAuthorizationToken() throws ServerException, InvalidParameterException, SdkBaseException, SdkClientException, ECRException {
        return this.getAuthorizationToken((GetAuthorizationTokenRequest)((Object)GetAuthorizationTokenRequest.builder().build()));
    }

    default public GetAuthorizationTokenResponse getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) throws ServerException, InvalidParameterException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetDownloadUrlForLayerResponse getDownloadUrlForLayer(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) throws ServerException, InvalidParameterException, LayersNotFoundException, LayerInaccessibleException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public GetRepositoryPolicyResponse getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public InitiateLayerUploadResponse initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public PutImageResponse putImage(PutImageRequest putImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public SetRepositoryPolicyResponse setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    default public UploadLayerPartResponse uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) throws ServerException, InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException, UploadNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ECRException {
        throw new UnsupportedOperationException();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

