/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ecr.model.Image;
import software.amazon.awssdk.services.ecr.transform.ImageIdentifierUnmarshaller;

public class ImageUnmarshaller
implements Unmarshaller<Image, JsonUnmarshallerContext> {
    private static final ImageUnmarshaller INSTANCE = new ImageUnmarshaller();

    public Image unmarshall(JsonUnmarshallerContext context) throws Exception {
        Image.Builder imageBuilder = Image.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("registryId", targetDepth)) {
                    context.nextToken();
                    imageBuilder.registryId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("repositoryName", targetDepth)) {
                    context.nextToken();
                    imageBuilder.repositoryName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("imageId", targetDepth)) {
                    context.nextToken();
                    imageBuilder.imageId(ImageIdentifierUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("imageManifest", targetDepth)) {
                    context.nextToken();
                    imageBuilder.imageManifest((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Image)imageBuilder.build();
    }

    public static ImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

