/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.transform.RepositoryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Repository
implements StructuredPojo,
ToCopyableBuilder<Builder, Repository> {
    private final String repositoryArn;
    private final String registryId;
    private final String repositoryName;
    private final String repositoryUri;
    private final Instant createdAt;

    private Repository(BuilderImpl builder) {
        this.repositoryArn = builder.repositoryArn;
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.repositoryUri = builder.repositoryUri;
        this.createdAt = builder.createdAt;
    }

    public String repositoryArn() {
        return this.repositoryArn;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String repositoryUri() {
        return this.repositoryUri;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.repositoryArn() == null ? 0 : this.repositoryArn().hashCode());
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.repositoryUri() == null ? 0 : this.repositoryUri().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)obj;
        if (other.repositoryArn() == null ^ this.repositoryArn() == null) {
            return false;
        }
        if (other.repositoryArn() != null && !other.repositoryArn().equals(this.repositoryArn())) {
            return false;
        }
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.repositoryUri() == null ^ this.repositoryUri() == null) {
            return false;
        }
        if (other.repositoryUri() != null && !other.repositoryUri().equals(this.repositoryUri())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        return other.createdAt() == null || other.createdAt().equals(this.createdAt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.repositoryArn() != null) {
            sb.append("RepositoryArn: ").append(this.repositoryArn()).append(",");
        }
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.repositoryUri() != null) {
            sb.append("RepositoryUri: ").append(this.repositoryUri()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String repositoryArn;
        private String registryId;
        private String repositoryName;
        private String repositoryUri;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            this.setRepositoryArn(model.repositoryArn);
            this.setRegistryId(model.registryId);
            this.setRepositoryName(model.repositoryName);
            this.setRepositoryUri(model.repositoryUri);
            this.setCreatedAt(model.createdAt);
        }

        public final String getRepositoryArn() {
            return this.repositoryArn;
        }

        @Override
        public final Builder repositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        public final void setRepositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getRepositoryUri() {
            return this.repositoryUri;
        }

        @Override
        public final Builder repositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
            return this;
        }

        public final void setRepositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public Repository build() {
            return new Repository(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Repository> {
        public Builder repositoryArn(String var1);

        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder repositoryUri(String var1);

        public Builder createdAt(Instant var1);
    }
}

