/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadLayerPartRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UploadLayerPartRequest> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long partFirstByte;
    private final Long partLastByte;
    private final ByteBuffer layerPartBlob;

    private UploadLayerPartRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.partFirstByte = builder.partFirstByte;
        this.partLastByte = builder.partLastByte;
        this.layerPartBlob = builder.layerPartBlob;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Long partFirstByte() {
        return this.partFirstByte;
    }

    public Long partLastByte() {
        return this.partLastByte;
    }

    public ByteBuffer layerPartBlob() {
        return this.layerPartBlob == null ? null : this.layerPartBlob.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.partFirstByte() == null ? 0 : this.partFirstByte().hashCode());
        hashCode = 31 * hashCode + (this.partLastByte() == null ? 0 : this.partLastByte().hashCode());
        hashCode = 31 * hashCode + (this.layerPartBlob() == null ? 0 : this.layerPartBlob().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadLayerPartRequest)) {
            return false;
        }
        UploadLayerPartRequest other = (UploadLayerPartRequest)((Object)obj);
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.partFirstByte() == null ^ this.partFirstByte() == null) {
            return false;
        }
        if (other.partFirstByte() != null && !other.partFirstByte().equals(this.partFirstByte())) {
            return false;
        }
        if (other.partLastByte() == null ^ this.partLastByte() == null) {
            return false;
        }
        if (other.partLastByte() != null && !other.partLastByte().equals(this.partLastByte())) {
            return false;
        }
        if (other.layerPartBlob() == null ^ this.layerPartBlob() == null) {
            return false;
        }
        return other.layerPartBlob() == null || other.layerPartBlob().equals(this.layerPartBlob());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.partFirstByte() != null) {
            sb.append("PartFirstByte: ").append(this.partFirstByte()).append(",");
        }
        if (this.partLastByte() != null) {
            sb.append("PartLastByte: ").append(this.partLastByte()).append(",");
        }
        if (this.layerPartBlob() != null) {
            sb.append("LayerPartBlob: ").append(this.layerPartBlob()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long partFirstByte;
        private Long partLastByte;
        private ByteBuffer layerPartBlob;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadLayerPartRequest model) {
            this.setRegistryId(model.registryId);
            this.setRepositoryName(model.repositoryName);
            this.setUploadId(model.uploadId);
            this.setPartFirstByte(model.partFirstByte);
            this.setPartLastByte(model.partLastByte);
            this.setLayerPartBlob(model.layerPartBlob);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getPartFirstByte() {
            return this.partFirstByte;
        }

        @Override
        public final Builder partFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
            return this;
        }

        public final void setPartFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
        }

        public final Long getPartLastByte() {
            return this.partLastByte;
        }

        @Override
        public final Builder partLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
            return this;
        }

        public final void setPartLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
        }

        public final ByteBuffer getLayerPartBlob() {
            return this.layerPartBlob;
        }

        @Override
        public final Builder layerPartBlob(ByteBuffer layerPartBlob) {
            this.layerPartBlob = StandardMemberCopier.copy((ByteBuffer)layerPartBlob);
            return this;
        }

        public final void setLayerPartBlob(ByteBuffer layerPartBlob) {
            this.layerPartBlob = StandardMemberCopier.copy((ByteBuffer)layerPartBlob);
        }

        public UploadLayerPartRequest build() {
            return new UploadLayerPartRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadLayerPartRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder partFirstByte(Long var1);

        public Builder partLastByte(Long var1);

        public Builder layerPartBlob(ByteBuffer var1);
    }
}

