/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.LayerAvailability;
import software.amazon.awssdk.services.ecr.transform.LayerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Layer
implements StructuredPojo,
ToCopyableBuilder<Builder, Layer> {
    private final String layerDigest;
    private final String layerAvailability;
    private final Long layerSize;
    private final String mediaType;

    private Layer(BuilderImpl builder) {
        this.layerDigest = builder.layerDigest;
        this.layerAvailability = builder.layerAvailability;
        this.layerSize = builder.layerSize;
        this.mediaType = builder.mediaType;
    }

    public String layerDigest() {
        return this.layerDigest;
    }

    public String layerAvailability() {
        return this.layerAvailability;
    }

    public Long layerSize() {
        return this.layerSize;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.layerDigest() == null ? 0 : this.layerDigest().hashCode());
        hashCode = 31 * hashCode + (this.layerAvailability() == null ? 0 : this.layerAvailability().hashCode());
        hashCode = 31 * hashCode + (this.layerSize() == null ? 0 : this.layerSize().hashCode());
        hashCode = 31 * hashCode + (this.mediaType() == null ? 0 : this.mediaType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)obj;
        if (other.layerDigest() == null ^ this.layerDigest() == null) {
            return false;
        }
        if (other.layerDigest() != null && !other.layerDigest().equals(this.layerDigest())) {
            return false;
        }
        if (other.layerAvailability() == null ^ this.layerAvailability() == null) {
            return false;
        }
        if (other.layerAvailability() != null && !other.layerAvailability().equals(this.layerAvailability())) {
            return false;
        }
        if (other.layerSize() == null ^ this.layerSize() == null) {
            return false;
        }
        if (other.layerSize() != null && !other.layerSize().equals(this.layerSize())) {
            return false;
        }
        if (other.mediaType() == null ^ this.mediaType() == null) {
            return false;
        }
        return other.mediaType() == null || other.mediaType().equals(this.mediaType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.layerDigest() != null) {
            sb.append("LayerDigest: ").append(this.layerDigest()).append(",");
        }
        if (this.layerAvailability() != null) {
            sb.append("LayerAvailability: ").append(this.layerAvailability()).append(",");
        }
        if (this.layerSize() != null) {
            sb.append("LayerSize: ").append(this.layerSize()).append(",");
        }
        if (this.mediaType() != null) {
            sb.append("MediaType: ").append(this.mediaType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String layerDigest;
        private String layerAvailability;
        private Long layerSize;
        private String mediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            this.setLayerDigest(model.layerDigest);
            this.setLayerAvailability(model.layerAvailability);
            this.setLayerSize(model.layerSize);
            this.setMediaType(model.mediaType);
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        public final String getLayerAvailability() {
            return this.layerAvailability;
        }

        @Override
        public final Builder layerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
            return this;
        }

        @Override
        public final Builder layerAvailability(LayerAvailability layerAvailability) {
            this.layerAvailability(layerAvailability.toString());
            return this;
        }

        public final void setLayerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
        }

        public final void setLayerAvailability(LayerAvailability layerAvailability) {
            this.layerAvailability(layerAvailability.toString());
        }

        public final Long getLayerSize() {
            return this.layerSize;
        }

        @Override
        public final Builder layerSize(Long layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public final void setLayerSize(Long layerSize) {
            this.layerSize = layerSize;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public Layer build() {
            return new Layer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Layer> {
        public Builder layerDigest(String var1);

        public Builder layerAvailability(String var1);

        public Builder layerAvailability(LayerAvailability var1);

        public Builder layerSize(Long var1);

        public Builder mediaType(String var1);
    }
}

