/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.transform.ImageIdentifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageIdentifier> {
    private final String imageDigest;
    private final String imageTag;

    private ImageIdentifier(BuilderImpl builder) {
        this.imageDigest = builder.imageDigest;
        this.imageTag = builder.imageTag;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public String imageTag() {
        return this.imageTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.imageDigest() == null ? 0 : this.imageDigest().hashCode());
        hashCode = 31 * hashCode + (this.imageTag() == null ? 0 : this.imageTag().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageIdentifier)) {
            return false;
        }
        ImageIdentifier other = (ImageIdentifier)obj;
        if (other.imageDigest() == null ^ this.imageDigest() == null) {
            return false;
        }
        if (other.imageDigest() != null && !other.imageDigest().equals(this.imageDigest())) {
            return false;
        }
        if (other.imageTag() == null ^ this.imageTag() == null) {
            return false;
        }
        return other.imageTag() == null || other.imageTag().equals(this.imageTag());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageDigest() != null) {
            sb.append("ImageDigest: ").append(this.imageDigest()).append(",");
        }
        if (this.imageTag() != null) {
            sb.append("ImageTag: ").append(this.imageTag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String imageDigest;
        private String imageTag;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageIdentifier model) {
            this.setImageDigest(model.imageDigest);
            this.setImageTag(model.imageTag);
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        public ImageIdentifier build() {
            return new ImageIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageIdentifier> {
        public Builder imageDigest(String var1);

        public Builder imageTag(String var1);
    }
}

