/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRegistryIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAuthorizationTokenRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetAuthorizationTokenRequest> {
    private final List<String> registryIds;

    private GetAuthorizationTokenRequest(BuilderImpl builder) {
        this.registryIds = builder.registryIds;
    }

    public List<String> registryIds() {
        return this.registryIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryIds() == null ? 0 : this.registryIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenRequest)) {
            return false;
        }
        GetAuthorizationTokenRequest other = (GetAuthorizationTokenRequest)((Object)obj);
        if (other.registryIds() == null ^ this.registryIds() == null) {
            return false;
        }
        return other.registryIds() == null || other.registryIds().equals(this.registryIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.registryIds() != null) {
            sb.append("RegistryIds: ").append(this.registryIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> registryIds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenRequest model) {
            this.setRegistryIds(model.registryIds);
        }

        public final Collection<String> getRegistryIds() {
            return this.registryIds;
        }

        @Override
        public final Builder registryIds(Collection<String> registryIds) {
            this.registryIds = GetAuthorizationTokenRegistryIdListCopier.copy(registryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registryIds(String ... registryIds) {
            this.registryIds(Arrays.asList(registryIds));
            return this;
        }

        public final void setRegistryIds(Collection<String> registryIds) {
            this.registryIds = GetAuthorizationTokenRegistryIdListCopier.copy(registryIds);
        }

        @SafeVarargs
        public final void setRegistryIds(String ... registryIds) {
            this.registryIds(Arrays.asList(registryIds));
        }

        public GetAuthorizationTokenRequest build() {
            return new GetAuthorizationTokenRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAuthorizationTokenRequest> {
        public Builder registryIds(Collection<String> var1);

        public Builder registryIds(String ... var1);
    }
}

