/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.ImageDetail;
import software.amazon.awssdk.services.ecr.model.ImageDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImagesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeImagesResponse> {
    private final List<ImageDetail> imageDetails;
    private final String nextToken;

    private DescribeImagesResponse(BuilderImpl builder) {
        this.imageDetails = builder.imageDetails;
        this.nextToken = builder.nextToken;
    }

    public List<ImageDetail> imageDetails() {
        return this.imageDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.imageDetails() == null ? 0 : this.imageDetails().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse)((Object)obj);
        if (other.imageDetails() == null ^ this.imageDetails() == null) {
            return false;
        }
        if (other.imageDetails() != null && !other.imageDetails().equals(this.imageDetails())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageDetails() != null) {
            sb.append("ImageDetails: ").append(this.imageDetails()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ImageDetail> imageDetails;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            this.setImageDetails(model.imageDetails);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ImageDetail> getImageDetails() {
            return this.imageDetails;
        }

        @Override
        public final Builder imageDetails(Collection<ImageDetail> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copy(imageDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageDetails(ImageDetail ... imageDetails) {
            this.imageDetails(Arrays.asList(imageDetails));
            return this;
        }

        public final void setImageDetails(Collection<ImageDetail> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copy(imageDetails);
        }

        @SafeVarargs
        public final void setImageDetails(ImageDetail ... imageDetails) {
            this.imageDetails(Arrays.asList(imageDetails));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeImagesResponse> {
        public Builder imageDetails(Collection<ImageDetail> var1);

        public Builder imageDetails(ImageDetail ... var1);

        public Builder nextToken(String var1);
    }
}

