/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.Image;
import software.amazon.awssdk.services.ecr.model.ImageFailure;
import software.amazon.awssdk.services.ecr.model.ImageFailureListCopier;
import software.amazon.awssdk.services.ecr.model.ImageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetImageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetImageResponse> {
    private final List<Image> images;
    private final List<ImageFailure> failures;

    private BatchGetImageResponse(BuilderImpl builder) {
        this.images = builder.images;
        this.failures = builder.failures;
    }

    public List<Image> images() {
        return this.images;
    }

    public List<ImageFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.images() == null ? 0 : this.images().hashCode());
        hashCode = 31 * hashCode + (this.failures() == null ? 0 : this.failures().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageResponse)) {
            return false;
        }
        BatchGetImageResponse other = (BatchGetImageResponse)((Object)obj);
        if (other.images() == null ^ this.images() == null) {
            return false;
        }
        if (other.images() != null && !other.images().equals(this.images())) {
            return false;
        }
        if (other.failures() == null ^ this.failures() == null) {
            return false;
        }
        return other.failures() == null || other.failures().equals(this.failures());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.images() != null) {
            sb.append("Images: ").append(this.images()).append(",");
        }
        if (this.failures() != null) {
            sb.append("Failures: ").append(this.failures()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Image> images;
        private List<ImageFailure> failures;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetImageResponse model) {
            this.setImages(model.images);
            this.setFailures(model.failures);
        }

        public final Collection<Image> getImages() {
            return this.images;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        public final void setImages(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
        }

        @SafeVarargs
        public final void setImages(Image ... images) {
            this.images(Arrays.asList(images));
        }

        public final Collection<ImageFailure> getFailures() {
            return this.failures;
        }

        @Override
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ImageFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        public final void setFailures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
        }

        @SafeVarargs
        public final void setFailures(ImageFailure ... failures) {
            this.failures(Arrays.asList(failures));
        }

        public BatchGetImageResponse build() {
            return new BatchGetImageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetImageResponse> {
        public Builder images(Collection<Image> var1);

        public Builder images(Image ... var1);

        public Builder failures(Collection<ImageFailure> var1);

        public Builder failures(ImageFailure ... var1);
    }
}

