/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ecr.ECRClient;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecr.model.BatchGetImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchGetImageResponse;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.ECRException;
import software.amazon.awssdk.services.ecr.model.EmptyUploadException;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerRequest;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerResponse;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.InvalidLayerException;
import software.amazon.awssdk.services.ecr.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecr.model.InvalidParameterException;
import software.amazon.awssdk.services.ecr.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.LayerInaccessibleException;
import software.amazon.awssdk.services.ecr.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecr.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecr.model.LimitExceededException;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;
import software.amazon.awssdk.services.ecr.model.PutImageRequest;
import software.amazon.awssdk.services.ecr.model.PutImageResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecr.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecr.model.ServerException;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecr.model.UploadNotFoundException;
import software.amazon.awssdk.services.ecr.transform.BatchCheckLayerAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.BatchCheckLayerAvailabilityResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.BatchDeleteImageRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.BatchDeleteImageResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.BatchGetImageRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.BatchGetImageResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.CompleteLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.CompleteLayerUploadResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.CreateRepositoryResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.DeleteRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.DeleteRepositoryPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.DeleteRepositoryResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.DescribeImagesResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.DescribeRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.DescribeRepositoriesResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.GetAuthorizationTokenRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.GetAuthorizationTokenResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.GetDownloadUrlForLayerRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.GetDownloadUrlForLayerResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.GetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.GetRepositoryPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.InitiateLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.InitiateLayerUploadResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.ListImagesResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.PutImageRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.PutImageResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.SetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.SetRepositoryPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.ecr.transform.UploadLayerPartRequestMarshaller;
import software.amazon.awssdk.services.ecr.transform.UploadLayerPartResponseUnmarshaller;

@SdkInternalApi
final class DefaultECRClient
implements ECRClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultECRClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) throws RepositoryNotFoundException, InvalidParameterException, ServerException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new BatchCheckLayerAvailabilityResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BatchCheckLayerAvailabilityResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)batchCheckLayerAvailabilityRequest).withMarshaller((Marshaller)new BatchCheckLayerAvailabilityRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public BatchDeleteImageResponse batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new BatchDeleteImageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BatchDeleteImageResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)batchDeleteImageRequest).withMarshaller((Marshaller)new BatchDeleteImageRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public BatchGetImageResponse batchGetImage(BatchGetImageRequest batchGetImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new BatchGetImageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BatchGetImageResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)batchGetImageRequest).withMarshaller((Marshaller)new BatchGetImageRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CompleteLayerUploadResponse completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException, InvalidLayerException, LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CompleteLayerUploadResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CompleteLayerUploadResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)completeLayerUploadRequest).withMarshaller((Marshaller)new CompleteLayerUploadRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryAlreadyExistsException, LimitExceededException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateRepositoryResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateRepositoryResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createRepositoryRequest).withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteRepositoryResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteRepositoryResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteRepositoryRequest).withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteRepositoryPolicyResponse deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteRepositoryPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteRepositoryPolicyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteRepositoryPolicyRequest).withMarshaller((Marshaller)new DeleteRepositoryPolicyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeImagesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeImagesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeImagesRequest).withMarshaller((Marshaller)new DescribeImagesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeRepositoriesResponse describeRepositories() throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        return this.describeRepositories((DescribeRepositoriesRequest)((Object)DescribeRepositoriesRequest.builder().build()));
    }

    @Override
    public DescribeRepositoriesResponse describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeRepositoriesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeRepositoriesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeRepositoriesRequest).withMarshaller((Marshaller)new DescribeRepositoriesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetAuthorizationTokenResponse getAuthorizationToken() throws ServerException, InvalidParameterException, SdkBaseException, SdkClientException, ECRException {
        return this.getAuthorizationToken((GetAuthorizationTokenRequest)((Object)GetAuthorizationTokenRequest.builder().build()));
    }

    @Override
    public GetAuthorizationTokenResponse getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) throws ServerException, InvalidParameterException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetAuthorizationTokenResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetAuthorizationTokenResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getAuthorizationTokenRequest).withMarshaller((Marshaller)new GetAuthorizationTokenRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetDownloadUrlForLayerResponse getDownloadUrlForLayer(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) throws ServerException, InvalidParameterException, LayersNotFoundException, LayerInaccessibleException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetDownloadUrlForLayerResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDownloadUrlForLayerResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getDownloadUrlForLayerRequest).withMarshaller((Marshaller)new GetDownloadUrlForLayerRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetRepositoryPolicyResponse getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetRepositoryPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetRepositoryPolicyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getRepositoryPolicyRequest).withMarshaller((Marshaller)new GetRepositoryPolicyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public InitiateLayerUploadResponse initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new InitiateLayerUploadResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InitiateLayerUploadResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)initiateLayerUploadRequest).withMarshaller((Marshaller)new InitiateLayerUploadRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListImagesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListImagesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listImagesRequest).withMarshaller((Marshaller)new ListImagesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public PutImageResponse putImage(PutImageRequest putImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PutImageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutImageResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)putImageRequest).withMarshaller((Marshaller)new PutImageRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SetRepositoryPolicyResponse setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SetRepositoryPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetRepositoryPolicyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)setRepositoryPolicyRequest).withMarshaller((Marshaller)new SetRepositoryPolicyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UploadLayerPartResponse uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) throws ServerException, InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException, UploadNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ECRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UploadLayerPartResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UploadLayerPartResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)uploadLayerPartRequest).withMarshaller((Marshaller)new UploadLayerPartRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(ECRException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerPartTooSmallException").withModeledClass(LayerPartTooSmallException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerPartException").withModeledClass(InvalidLayerPartException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerException").withModeledClass(ServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotEmptyException").withModeledClass(RepositoryNotEmptyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerAlreadyExistsException").withModeledClass(LayerAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EmptyUploadException").withModeledClass(EmptyUploadException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageNotFoundException").withModeledClass(ImageNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayersNotFoundException").withModeledClass(LayersNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerException").withModeledClass(InvalidLayerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotFoundException").withModeledClass(RepositoryNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryAlreadyExistsException").withModeledClass(RepositoryAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryPolicyNotFoundException").withModeledClass(RepositoryPolicyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageAlreadyExistsException").withModeledClass(ImageAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerInaccessibleException").withModeledClass(LayerInaccessibleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UploadNotFoundException").withModeledClass(UploadNotFoundException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

