/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.Repository;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RepositoryMarshaller {
    private static final MarshallingInfo<String> REPOSITORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryArn").isBinary(false).build();
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").isBinary(false).build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").isBinary(false).build();
    private static final MarshallingInfo<String> REPOSITORYURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryUri").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final RepositoryMarshaller INSTANCE = new RepositoryMarshaller();

    private RepositoryMarshaller() {
    }

    public static RepositoryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Repository repository, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)repository, (String)"repository");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)repository.repositoryArn(), REPOSITORYARN_BINDING);
            protocolMarshaller.marshall((Object)repository.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)repository.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall((Object)repository.repositoryUri(), REPOSITORYURI_BINDING);
            protocolMarshaller.marshall((Object)repository.createdAt(), CREATEDAT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

