/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImageIdentifierMarshaller {
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTag").isBinary(false).build();
    private static final ImageIdentifierMarshaller INSTANCE = new ImageIdentifierMarshaller();

    private ImageIdentifierMarshaller() {
    }

    public static ImageIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImageIdentifier imageIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)imageIdentifier, (String)"imageIdentifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)imageIdentifier.imageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall((Object)imageIdentifier.imageTag(), IMAGETAG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

