/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ecr.model.ImageDetail;

public class ImageDetailUnmarshaller
implements Unmarshaller<ImageDetail, JsonUnmarshallerContext> {
    private static final ImageDetailUnmarshaller INSTANCE = new ImageDetailUnmarshaller();

    public ImageDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        ImageDetail.Builder imageDetailBuilder = ImageDetail.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("registryId", targetDepth)) {
                    context.nextToken();
                    imageDetailBuilder.registryId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("repositoryName", targetDepth)) {
                    context.nextToken();
                    imageDetailBuilder.repositoryName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("imageDigest", targetDepth)) {
                    context.nextToken();
                    imageDetailBuilder.imageDigest((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("imageTags", targetDepth)) {
                    context.nextToken();
                    imageDetailBuilder.imageTags(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("imageSizeInBytes", targetDepth)) {
                    context.nextToken();
                    imageDetailBuilder.imageSizeInBytes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("imagePushedAt", targetDepth)) {
                    context.nextToken();
                    imageDetailBuilder.imagePushedAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ImageDetail)imageDetailBuilder.build();
    }

    public static ImageDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}

