/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDeleteImageRequestModelMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").isBinary(false).build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").isBinary(false).build();
    private static final MarshallingInfo<List> IMAGEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageIds").isBinary(false).build();
    private static final BatchDeleteImageRequestModelMarshaller INSTANCE = new BatchDeleteImageRequestModelMarshaller();

    private BatchDeleteImageRequestModelMarshaller() {
    }

    public static BatchDeleteImageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDeleteImageRequest batchDeleteImageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchDeleteImageRequest), (String)"batchDeleteImageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchDeleteImageRequest.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)batchDeleteImageRequest.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall(batchDeleteImageRequest.imageIds(), IMAGEIDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

