/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuthorizationDataMarshaller {
    private static final MarshallingInfo<String> AUTHORIZATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationToken").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRESAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expiresAt").isBinary(false).build();
    private static final MarshallingInfo<String> PROXYENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("proxyEndpoint").isBinary(false).build();
    private static final AuthorizationDataMarshaller INSTANCE = new AuthorizationDataMarshaller();

    private AuthorizationDataMarshaller() {
    }

    public static AuthorizationDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuthorizationData authorizationData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)authorizationData, (String)"authorizationData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)authorizationData.authorizationToken(), AUTHORIZATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)authorizationData.expiresAt(), EXPIRESAT_BINDING);
            protocolMarshaller.marshall((Object)authorizationData.proxyEndpoint(), PROXYENDPOINT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

