/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.Repository;

public class DescribeRepositoriesPublisher
implements SdkPublisher<DescribeRepositoriesResponse> {
    private final EcrAsyncClient client;
    private final DescribeRepositoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRepositoriesPublisher(EcrAsyncClient client, DescribeRepositoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRepositoriesPublisher(EcrAsyncClient client, DescribeRepositoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRepositoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRepositoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Repository> repositories() {
        Function<DescribeRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRepositoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeRepositoriesPublisher resume(DescribeRepositoriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeRepositoriesPublisher(this.client, (DescribeRepositoriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeRepositoriesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeRepositoriesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeRepositoriesResponseFetcher
    implements AsyncPageFetcher<DescribeRepositoriesResponse> {
        private DescribeRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRepositoriesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeRepositoriesResponse> nextPage(DescribeRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRepositoriesPublisher.this.client.describeRepositories(DescribeRepositoriesPublisher.this.firstRequest);
            }
            return DescribeRepositoriesPublisher.this.client.describeRepositories((DescribeRepositoriesRequest)((Object)DescribeRepositoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

