/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.ImageDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImageDetailMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").isBinary(false).build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").isBinary(false).build();
    private static final MarshallingInfo<List> IMAGETAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTags").isBinary(false).build();
    private static final MarshallingInfo<Long> IMAGESIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageSizeInBytes").isBinary(false).build();
    private static final MarshallingInfo<Instant> IMAGEPUSHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePushedAt").isBinary(false).build();
    private static final ImageDetailMarshaller INSTANCE = new ImageDetailMarshaller();

    private ImageDetailMarshaller() {
    }

    public static ImageDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImageDetail imageDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)imageDetail, (String)"imageDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)imageDetail.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.imageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall(imageDetail.imageTags(), IMAGETAGS_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.imageSizeInBytes(), IMAGESIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.imagePushedAt(), IMAGEPUSHEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

