/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ecr.ECRAsyncClient;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.Repository;

public class DescribeRepositoriesPublisher
implements SdkPublisher<DescribeRepositoriesResponse> {
    private final ECRAsyncClient client;
    private final DescribeRepositoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRepositoriesPublisher(ECRAsyncClient client, DescribeRepositoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRepositoriesPublisher(ECRAsyncClient client, DescribeRepositoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRepositoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRepositoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Repository> repositories() {
        Function<DescribeRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeRepositoriesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeRepositoriesPublisher resume(DescribeRepositoriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeRepositoriesPublisher(this.client, (DescribeRepositoriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeRepositoriesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeRepositoriesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeRepositoriesResponseFetcher
    implements AsyncPageFetcher<DescribeRepositoriesResponse> {
        private DescribeRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRepositoriesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeRepositoriesResponse> nextPage(DescribeRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRepositoriesPublisher.this.client.describeRepositories(DescribeRepositoriesPublisher.this.firstRequest);
            }
            return DescribeRepositoriesPublisher.this.client.describeRepositories((DescribeRepositoriesRequest)((Object)DescribeRepositoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

