/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.transform.RepositoryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Repository
implements StructuredPojo,
ToCopyableBuilder<Builder, Repository> {
    private final String repositoryArn;
    private final String registryId;
    private final String repositoryName;
    private final String repositoryUri;
    private final Instant createdAt;

    private Repository(BuilderImpl builder) {
        this.repositoryArn = builder.repositoryArn;
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.repositoryUri = builder.repositoryUri;
        this.createdAt = builder.createdAt;
    }

    public String repositoryArn() {
        return this.repositoryArn;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String repositoryUri() {
        return this.repositoryUri;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)obj;
        return Objects.equals(this.repositoryArn(), other.repositoryArn()) && Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryUri(), other.repositoryUri()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public String toString() {
        return ToString.builder((String)"Repository").add("RepositoryArn", (Object)this.repositoryArn()).add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("RepositoryUri", (Object)this.repositoryUri()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryArn": {
                return Optional.of(clazz.cast(this.repositoryArn()));
            }
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "repositoryUri": {
                return Optional.of(clazz.cast(this.repositoryUri()));
            }
            case "createdAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryArn;
        private String registryId;
        private String repositoryName;
        private String repositoryUri;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            this.repositoryArn(model.repositoryArn);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.repositoryUri(model.repositoryUri);
            this.createdAt(model.createdAt);
        }

        public final String getRepositoryArn() {
            return this.repositoryArn;
        }

        @Override
        public final Builder repositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        public final void setRepositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getRepositoryUri() {
            return this.repositoryUri;
        }

        @Override
        public final Builder repositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
            return this;
        }

        public final void setRepositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public Repository build() {
            return new Repository(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Repository> {
        public Builder repositoryArn(String var1);

        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder repositoryUri(String var1);

        public Builder createdAt(Instant var1);
    }
}

