/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.RouteTable;

public class DescribeRouteTablesIterable
implements SdkIterable<DescribeRouteTablesResponse> {
    private final Ec2Client client;
    private final DescribeRouteTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRouteTablesIterable(Ec2Client client, DescribeRouteTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRouteTablesResponseFetcher();
    }

    public Iterator<DescribeRouteTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RouteTable> routeTables() {
        Function<DescribeRouteTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routeTables() != null) {
                return response.routeTables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRouteTablesResponseFetcher
    implements SyncPageFetcher<DescribeRouteTablesResponse> {
        private DescribeRouteTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRouteTablesResponse nextPage(DescribeRouteTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteTablesIterable.this.client.describeRouteTables(DescribeRouteTablesIterable.this.firstRequest);
            }
            return DescribeRouteTablesIterable.this.client.describeRouteTables((DescribeRouteTablesRequest)((Object)DescribeRouteTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

