/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AllowedPrincipal;
import software.amazon.awssdk.services.ec2.model.AllowedPrincipalSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointServicePermissionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointServicePermissionsResponse> {
    private static final SdkField<List<AllowedPrincipal>> ALLOWED_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeVpcEndpointServicePermissionsResponse.getter(DescribeVpcEndpointServicePermissionsResponse::allowedPrincipals)).setter(DescribeVpcEndpointServicePermissionsResponse.setter(Builder::allowedPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPrincipals").unmarshallLocationName("allowedPrincipals").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AllowedPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVpcEndpointServicePermissionsResponse.getter(DescribeVpcEndpointServicePermissionsResponse::nextToken)).setter(DescribeVpcEndpointServicePermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_PRINCIPALS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AllowedPrincipal> allowedPrincipals;
    private final String nextToken;

    private DescribeVpcEndpointServicePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.allowedPrincipals = builder.allowedPrincipals;
        this.nextToken = builder.nextToken;
    }

    public List<AllowedPrincipal> allowedPrincipals() {
        return this.allowedPrincipals;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicePermissionsResponse)) {
            return false;
        }
        DescribeVpcEndpointServicePermissionsResponse other = (DescribeVpcEndpointServicePermissionsResponse)((Object)obj);
        return Objects.equals(this.allowedPrincipals(), other.allowedPrincipals()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcEndpointServicePermissionsResponse").add("AllowedPrincipals", this.allowedPrincipals()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.allowedPrincipals()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointServicePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointServicePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<AllowedPrincipal> allowedPrincipals = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicePermissionsResponse model) {
            super(model);
            this.allowedPrincipals(model.allowedPrincipals);
            this.nextToken(model.nextToken);
        }

        public final Collection<AllowedPrincipal.Builder> getAllowedPrincipals() {
            return this.allowedPrincipals != null ? (Collection)this.allowedPrincipals.stream().map(AllowedPrincipal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder allowedPrincipals(Collection<AllowedPrincipal> allowedPrincipals) {
            this.allowedPrincipals = AllowedPrincipalSetCopier.copy(allowedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedPrincipals(AllowedPrincipal ... allowedPrincipals) {
            this.allowedPrincipals(Arrays.asList(allowedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedPrincipals(Consumer<AllowedPrincipal.Builder> ... allowedPrincipals) {
            this.allowedPrincipals(Stream.of(allowedPrincipals).map(c -> (AllowedPrincipal)((AllowedPrincipal.Builder)AllowedPrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAllowedPrincipals(Collection<AllowedPrincipal.BuilderImpl> allowedPrincipals) {
            this.allowedPrincipals = AllowedPrincipalSetCopier.copyFromBuilder(allowedPrincipals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointServicePermissionsResponse build() {
            return new DescribeVpcEndpointServicePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEndpointServicePermissionsResponse> {
        public Builder allowedPrincipals(Collection<AllowedPrincipal> var1);

        public Builder allowedPrincipals(AllowedPrincipal ... var1);

        public Builder allowedPrincipals(Consumer<AllowedPrincipal.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

