/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.MoveStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MovingAddressStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MovingAddressStatus> {
    private static final SdkField<String> MOVE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MovingAddressStatus.getter(MovingAddressStatus::moveStatusAsString)).setter(MovingAddressStatus.setter(Builder::moveStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoveStatus").unmarshallLocationName("moveStatus").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MovingAddressStatus.getter(MovingAddressStatus::publicIp)).setter(MovingAddressStatus.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOVE_STATUS_FIELD, PUBLIC_IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String moveStatus;
    private final String publicIp;

    private MovingAddressStatus(BuilderImpl builder) {
        this.moveStatus = builder.moveStatus;
        this.publicIp = builder.publicIp;
    }

    public MoveStatus moveStatus() {
        return MoveStatus.fromValue(this.moveStatus);
    }

    public String moveStatusAsString() {
        return this.moveStatus;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.moveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MovingAddressStatus)) {
            return false;
        }
        MovingAddressStatus other = (MovingAddressStatus)obj;
        return Objects.equals(this.moveStatusAsString(), other.moveStatusAsString()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public String toString() {
        return ToString.builder((String)"MovingAddressStatus").add("MoveStatus", (Object)this.moveStatusAsString()).add("PublicIp", (Object)this.publicIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MoveStatus": {
                return Optional.ofNullable(clazz.cast(this.moveStatusAsString()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MovingAddressStatus, T> g) {
        return obj -> g.apply((MovingAddressStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String moveStatus;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(MovingAddressStatus model) {
            this.moveStatus(model.moveStatus);
            this.publicIp(model.publicIp);
        }

        public final String getMoveStatusAsString() {
            return this.moveStatus;
        }

        @Override
        public final Builder moveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
            return this;
        }

        @Override
        public final Builder moveStatus(MoveStatus moveStatus) {
            this.moveStatus(moveStatus.toString());
            return this;
        }

        public final void setMoveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public MovingAddressStatus build() {
            return new MovingAddressStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MovingAddressStatus> {
        public Builder moveStatus(String var1);

        public Builder moveStatus(MoveStatus var1);

        public Builder publicIp(String var1);
    }
}

