/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vpc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vpc> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Vpc.getter(Vpc::cidrBlock)).setter(Vpc.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Vpc.getter(Vpc::dhcpOptionsId)).setter(Vpc.setter(Builder::dhcpOptionsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId").unmarshallLocationName("dhcpOptionsId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Vpc.getter(Vpc::stateAsString)).setter(Vpc.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Vpc.getter(Vpc::vpcId)).setter(Vpc.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Vpc.getter(Vpc::ownerId)).setter(Vpc.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Vpc.getter(Vpc::instanceTenancyAsString)).setter(Vpc.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final SdkField<List<VpcIpv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Vpc.getter(Vpc::ipv6CidrBlockAssociationSet)).setter(Vpc.setter(Builder::ipv6CidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet").unmarshallLocationName("ipv6CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcIpv6CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<VpcCidrBlockAssociation>> CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Vpc.getter(Vpc::cidrBlockAssociationSet)).setter(Vpc.setter(Builder::cidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockAssociationSet").unmarshallLocationName("cidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcCidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Vpc.getter(Vpc::isDefault)).setter(Vpc.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").unmarshallLocationName("isDefault").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Vpc.getter(Vpc::tags)).setter(Vpc.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD, DHCP_OPTIONS_ID_FIELD, STATE_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD, INSTANCE_TENANCY_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD, CIDR_BLOCK_ASSOCIATION_SET_FIELD, IS_DEFAULT_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidrBlock;
    private final String dhcpOptionsId;
    private final String state;
    private final String vpcId;
    private final String ownerId;
    private final String instanceTenancy;
    private final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
    private final List<VpcCidrBlockAssociation> cidrBlockAssociationSet;
    private final Boolean isDefault;
    private final List<Tag> tags;

    private Vpc(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.state = builder.state;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.cidrBlockAssociationSet = builder.cidrBlockAssociationSet;
        this.isDefault = builder.isDefault;
        this.tags = builder.tags;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public VpcState state() {
        return VpcState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet;
    }

    public List<VpcCidrBlockAssociation> cidrBlockAssociationSet() {
        return this.cidrBlockAssociationSet;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockAssociationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlockAssociationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc)obj;
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet()) && Objects.equals(this.cidrBlockAssociationSet(), other.cidrBlockAssociationSet()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Vpc").add("CidrBlock", (Object)this.cidrBlock()).add("DhcpOptionsId", (Object)this.dhcpOptionsId()).add("State", (Object)this.stateAsString()).add("VpcId", (Object)this.vpcId()).add("OwnerId", (Object)this.ownerId()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("Ipv6CidrBlockAssociationSet", this.ipv6CidrBlockAssociationSet()).add("CidrBlockAssociationSet", this.cidrBlockAssociationSet()).add("IsDefault", (Object)this.isDefault()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "DhcpOptionsId": {
                return Optional.ofNullable(clazz.cast(this.dhcpOptionsId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
            case "Ipv6CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockAssociationSet()));
            }
            case "CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockAssociationSet()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vpc, T> g) {
        return obj -> g.apply((Vpc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private String dhcpOptionsId;
        private String state;
        private String vpcId;
        private String ownerId;
        private String instanceTenancy;
        private List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();
        private List<VpcCidrBlockAssociation> cidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();
        private Boolean isDefault;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Vpc model) {
            this.cidrBlock(model.cidrBlock);
            this.dhcpOptionsId(model.dhcpOptionsId);
            this.state(model.state);
            this.vpcId(model.vpcId);
            this.ownerId(model.ownerId);
            this.instanceTenancy(model.instanceTenancy);
            this.ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            this.cidrBlockAssociationSet(model.cidrBlockAssociationSet);
            this.isDefault(model.isDefault);
            this.tags(model.tags);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getInstanceTenancyAsString() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Collection<VpcIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            return this.ipv6CidrBlockAssociationSet != null ? (Collection)this.ipv6CidrBlockAssociationSet.stream().map(VpcIpv6CidrBlockAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Consumer<VpcIpv6CidrBlockAssociation.Builder> ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet).map(c -> (VpcIpv6CidrBlockAssociation)((VpcIpv6CidrBlockAssociation.Builder)VpcIpv6CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        public final Collection<VpcCidrBlockAssociation.Builder> getCidrBlockAssociationSet() {
            return this.cidrBlockAssociationSet != null ? (Collection)this.cidrBlockAssociationSet.stream().map(VpcCidrBlockAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copy(cidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(VpcCidrBlockAssociation ... cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet(Arrays.asList(cidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder> ... cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet(Stream.of(cidrBlockAssociationSet).map(c -> (VpcCidrBlockAssociation)((VpcCidrBlockAssociation.Builder)VpcCidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCidrBlockAssociationSet(Collection<VpcCidrBlockAssociation.BuilderImpl> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copyFromBuilder(cidrBlockAssociationSet);
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public Vpc build() {
            return new Vpc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vpc> {
        public Builder cidrBlock(String var1);

        public Builder dhcpOptionsId(String var1);

        public Builder state(String var1);

        public Builder state(VpcState var1);

        public Builder vpcId(String var1);

        public Builder ownerId(String var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> var1);

        public Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation ... var1);

        public Builder ipv6CidrBlockAssociationSet(Consumer<VpcIpv6CidrBlockAssociation.Builder> ... var1);

        public Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> var1);

        public Builder cidrBlockAssociationSet(VpcCidrBlockAssociation ... var1);

        public Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder> ... var1);

        public Builder isDefault(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

