/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.TagDescription;

public class DescribeTagsPublisher
implements SdkPublisher<DescribeTagsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTagsPublisher(Ec2AsyncClient client, DescribeTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTagsPublisher(Ec2AsyncClient client, DescribeTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TagDescription> tags() {
        Function<DescribeTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTagsResponseFetcher
    implements AsyncPageFetcher<DescribeTagsResponse> {
        private DescribeTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTagsResponse> nextPage(DescribeTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTagsPublisher.this.client.describeTags(DescribeTagsPublisher.this.firstRequest);
            }
            return DescribeTagsPublisher.this.client.describeTags((DescribeTagsRequest)((Object)DescribeTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

