/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceType {
    CLIENT_VPN_ENDPOINT("client-vpn-endpoint"),
    CUSTOMER_GATEWAY("customer-gateway"),
    DEDICATED_HOST("dedicated-host"),
    DHCP_OPTIONS("dhcp-options"),
    ELASTIC_IP("elastic-ip"),
    FLEET("fleet"),
    FPGA_IMAGE("fpga-image"),
    IMAGE("image"),
    INSTANCE("instance"),
    INTERNET_GATEWAY("internet-gateway"),
    LAUNCH_TEMPLATE("launch-template"),
    NATGATEWAY("natgateway"),
    NETWORK_ACL("network-acl"),
    NETWORK_INTERFACE("network-interface"),
    RESERVED_INSTANCES("reserved-instances"),
    ROUTE_TABLE("route-table"),
    SECURITY_GROUP("security-group"),
    SNAPSHOT("snapshot"),
    SPOT_INSTANCES_REQUEST("spot-instances-request"),
    SUBNET("subnet"),
    TRANSIT_GATEWAY("transit-gateway"),
    TRANSIT_GATEWAY_ATTACHMENT("transit-gateway-attachment"),
    TRANSIT_GATEWAY_ROUTE_TABLE("transit-gateway-route-table"),
    VOLUME("volume"),
    VPC("vpc"),
    VPC_PEERING_CONNECTION("vpc-peering-connection"),
    VPN_CONNECTION("vpn-connection"),
    VPN_GATEWAY("vpn-gateway"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        return Stream.of(ResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

