/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInterfacePermissionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeNetworkInterfacePermissionsRequest> {
    private static final SdkField<List<String>> NETWORK_INTERFACE_PERMISSION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeNetworkInterfacePermissionsRequest.getter(DescribeNetworkInterfacePermissionsRequest::networkInterfacePermissionIds)).setter(DescribeNetworkInterfacePermissionsRequest.setter(Builder::networkInterfacePermissionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePermissionId").unmarshallLocationName("NetworkInterfacePermissionId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeNetworkInterfacePermissionsRequest.getter(DescribeNetworkInterfacePermissionsRequest::filters)).setter(DescribeNetworkInterfacePermissionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeNetworkInterfacePermissionsRequest.getter(DescribeNetworkInterfacePermissionsRequest::nextToken)).setter(DescribeNetworkInterfacePermissionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeNetworkInterfacePermissionsRequest.getter(DescribeNetworkInterfacePermissionsRequest::maxResults)).setter(DescribeNetworkInterfacePermissionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_PERMISSION_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> networkInterfacePermissionIds;
    private final List<Filter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeNetworkInterfacePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfacePermissionIds = builder.networkInterfacePermissionIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> networkInterfacePermissionIds() {
        return this.networkInterfacePermissionIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfacePermissionIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacePermissionsRequest)) {
            return false;
        }
        DescribeNetworkInterfacePermissionsRequest other = (DescribeNetworkInterfacePermissionsRequest)((Object)obj);
        return Objects.equals(this.networkInterfacePermissionIds(), other.networkInterfacePermissionIds()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNetworkInterfacePermissionsRequest").add("NetworkInterfacePermissionIds", this.networkInterfacePermissionIds()).add("Filters", this.filters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfacePermissionIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacePermissionIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInterfacePermissionsRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInterfacePermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> networkInterfacePermissionIds = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacePermissionsRequest model) {
            super(model);
            this.networkInterfacePermissionIds(model.networkInterfacePermissionIds);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getNetworkInterfacePermissionIds() {
            return this.networkInterfacePermissionIds;
        }

        @Override
        public final Builder networkInterfacePermissionIds(Collection<String> networkInterfacePermissionIds) {
            this.networkInterfacePermissionIds = NetworkInterfacePermissionIdListCopier.copy(networkInterfacePermissionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissionIds(String ... networkInterfacePermissionIds) {
            this.networkInterfacePermissionIds(Arrays.asList(networkInterfacePermissionIds));
            return this;
        }

        public final void setNetworkInterfacePermissionIds(Collection<String> networkInterfacePermissionIds) {
            this.networkInterfacePermissionIds = NetworkInterfacePermissionIdListCopier.copy(networkInterfacePermissionIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInterfacePermissionsRequest build() {
            return new DescribeNetworkInterfacePermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInterfacePermissionsRequest> {
        public Builder networkInterfacePermissionIds(Collection<String> var1);

        public Builder networkInterfacePermissionIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

