/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignPrivateIpAddressesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
    private static final SdkField<Boolean> ALLOW_REASSIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::allowReassignment)).setter(AssignPrivateIpAddressesRequest.setter(Builder::allowReassignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReassignment").unmarshallLocationName("allowReassignment").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::networkInterfaceId)).setter(AssignPrivateIpAddressesRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::privateIpAddresses)).setter(AssignPrivateIpAddressesRequest.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build(), ListTrait.builder().memberLocationName("PrivateIpAddress").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::secondaryPrivateIpAddressCount)).setter(AssignPrivateIpAddressesRequest.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("secondaryPrivateIpAddressCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_REASSIGNMENT_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD));
    private final Boolean allowReassignment;
    private final String networkInterfaceId;
    private final List<String> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;

    private AssignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.allowReassignment = builder.allowReassignment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
    }

    public Boolean allowReassignment() {
        return this.allowReassignment;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowReassignment());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest)((Object)obj);
        return Objects.equals(this.allowReassignment(), other.allowReassignment()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount());
    }

    public String toString() {
        return ToString.builder((String)"AssignPrivateIpAddressesRequest").add("AllowReassignment", (Object)this.allowReassignment()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddresses", this.privateIpAddresses()).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowReassignment": {
                return Optional.ofNullable(clazz.cast(this.allowReassignment()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesRequest, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean allowReassignment;
        private String networkInterfaceId;
        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesRequest model) {
            super(model);
            this.allowReassignment(model.allowReassignment);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddresses(model.privateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
        }

        public final Boolean getAllowReassignment() {
            return this.allowReassignment;
        }

        @Override
        public final Builder allowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
            return this;
        }

        public final void setAllowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignPrivateIpAddressesRequest build() {
            return new AssignPrivateIpAddressesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
        public Builder allowReassignment(Boolean var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

