/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteClientVpnRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteClientVpnRouteRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteClientVpnRouteRequest.getter(DeleteClientVpnRouteRequest::clientVpnEndpointId)).setter(DeleteClientVpnRouteRequest.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> TARGET_VPC_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteClientVpnRouteRequest.getter(DeleteClientVpnRouteRequest::targetVpcSubnetId)).setter(DeleteClientVpnRouteRequest.setter(Builder::targetVpcSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVpcSubnetId").unmarshallLocationName("TargetVpcSubnetId").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteClientVpnRouteRequest.getter(DeleteClientVpnRouteRequest::destinationCidrBlock)).setter(DeleteClientVpnRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, TARGET_VPC_SUBNET_ID_FIELD, DESTINATION_CIDR_BLOCK_FIELD));
    private final String clientVpnEndpointId;
    private final String targetVpcSubnetId;
    private final String destinationCidrBlock;

    private DeleteClientVpnRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.targetVpcSubnetId = builder.targetVpcSubnetId;
        this.destinationCidrBlock = builder.destinationCidrBlock;
    }

    public String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public String targetVpcSubnetId() {
        return this.targetVpcSubnetId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVpcSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClientVpnRouteRequest)) {
            return false;
        }
        DeleteClientVpnRouteRequest other = (DeleteClientVpnRouteRequest)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.targetVpcSubnetId(), other.targetVpcSubnetId()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock());
    }

    public String toString() {
        return ToString.builder((String)"DeleteClientVpnRouteRequest").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("TargetVpcSubnetId", (Object)this.targetVpcSubnetId()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "TargetVpcSubnetId": {
                return Optional.ofNullable(clazz.cast(this.targetVpcSubnetId()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClientVpnRouteRequest, T> g) {
        return obj -> g.apply((DeleteClientVpnRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String targetVpcSubnetId;
        private String destinationCidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClientVpnRouteRequest model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.targetVpcSubnetId(model.targetVpcSubnetId);
            this.destinationCidrBlock(model.destinationCidrBlock);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getTargetVpcSubnetId() {
            return this.targetVpcSubnetId;
        }

        @Override
        public final Builder targetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
            return this;
        }

        public final void setTargetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClientVpnRouteRequest build() {
            return new DeleteClientVpnRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteClientVpnRouteRequest> {
        public Builder clientVpnEndpointId(String var1);

        public Builder targetVpcSubnetId(String var1);

        public Builder destinationCidrBlock(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

