/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubnetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateSubnetRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSubnetRequest.getter(CreateSubnetRequest::availabilityZone)).setter(CreateSubnetRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSubnetRequest.getter(CreateSubnetRequest::availabilityZoneId)).setter(CreateSubnetRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSubnetRequest.getter(CreateSubnetRequest::cidrBlock)).setter(CreateSubnetRequest.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("CidrBlock").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSubnetRequest.getter(CreateSubnetRequest::ipv6CidrBlock)).setter(CreateSubnetRequest.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("Ipv6CidrBlock").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSubnetRequest.getter(CreateSubnetRequest::vpcId)).setter(CreateSubnetRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_FIELD, VPC_ID_FIELD));
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final String cidrBlock;
    private final String ipv6CidrBlock;
    private final String vpcId;

    private CreateSubnetRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.vpcId = builder.vpcId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetRequest)) {
            return false;
        }
        CreateSubnetRequest other = (CreateSubnetRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"CreateSubnetRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("CidrBlock", (Object)this.cidrBlock()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetRequest, T> g) {
        return obj -> g.apply((CreateSubnetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String availabilityZoneId;
        private String cidrBlock;
        private String ipv6CidrBlock;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.cidrBlock(model.cidrBlock);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.vpcId(model.vpcId);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetRequest build() {
            return new CreateSubnetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubnetRequest> {
        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder cidrBlock(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

