/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.EventCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStatusEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStatusEvent> {
    private static final SdkField<String> INSTANCE_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceStatusEvent.getter(InstanceStatusEvent::instanceEventId)).setter(InstanceStatusEvent.setter(Builder::instanceEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventId").unmarshallLocationName("instanceEventId").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceStatusEvent.getter(InstanceStatusEvent::codeAsString)).setter(InstanceStatusEvent.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").unmarshallLocationName("code").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceStatusEvent.getter(InstanceStatusEvent::description)).setter(InstanceStatusEvent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceStatusEvent.getter(InstanceStatusEvent::notAfter)).setter(InstanceStatusEvent.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").unmarshallLocationName("notAfter").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceStatusEvent.getter(InstanceStatusEvent::notBefore)).setter(InstanceStatusEvent.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").unmarshallLocationName("notBefore").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_DEADLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceStatusEvent.getter(InstanceStatusEvent::notBeforeDeadline)).setter(InstanceStatusEvent.setter(Builder::notBeforeDeadline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBeforeDeadline").unmarshallLocationName("notBeforeDeadline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_ID_FIELD, CODE_FIELD, DESCRIPTION_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD, NOT_BEFORE_DEADLINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceEventId;
    private final String code;
    private final String description;
    private final Instant notAfter;
    private final Instant notBefore;
    private final Instant notBeforeDeadline;

    private InstanceStatusEvent(BuilderImpl builder) {
        this.instanceEventId = builder.instanceEventId;
        this.code = builder.code;
        this.description = builder.description;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
        this.notBeforeDeadline = builder.notBeforeDeadline;
    }

    public String instanceEventId() {
        return this.instanceEventId;
    }

    public EventCode code() {
        return EventCode.fromValue(this.code);
    }

    public String codeAsString() {
        return this.code;
    }

    public String description() {
        return this.description;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Instant notBeforeDeadline() {
        return this.notBeforeDeadline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBeforeDeadline());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusEvent)) {
            return false;
        }
        InstanceStatusEvent other = (InstanceStatusEvent)obj;
        return Objects.equals(this.instanceEventId(), other.instanceEventId()) && Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.notBeforeDeadline(), other.notBeforeDeadline());
    }

    public String toString() {
        return ToString.builder((String)"InstanceStatusEvent").add("InstanceEventId", (Object)this.instanceEventId()).add("Code", (Object)this.codeAsString()).add("Description", (Object)this.description()).add("NotAfter", (Object)this.notAfter()).add("NotBefore", (Object)this.notBefore()).add("NotBeforeDeadline", (Object)this.notBeforeDeadline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceEventId": {
                return Optional.ofNullable(clazz.cast(this.instanceEventId()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "NotBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "NotBeforeDeadline": {
                return Optional.ofNullable(clazz.cast(this.notBeforeDeadline()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatusEvent, T> g) {
        return obj -> g.apply((InstanceStatusEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceEventId;
        private String code;
        private String description;
        private Instant notAfter;
        private Instant notBefore;
        private Instant notBeforeDeadline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusEvent model) {
            this.instanceEventId(model.instanceEventId);
            this.code(model.code);
            this.description(model.description);
            this.notAfter(model.notAfter);
            this.notBefore(model.notBefore);
            this.notBeforeDeadline(model.notBeforeDeadline);
        }

        public final String getInstanceEventId() {
            return this.instanceEventId;
        }

        @Override
        public final Builder instanceEventId(String instanceEventId) {
            this.instanceEventId = instanceEventId;
            return this;
        }

        public final void setInstanceEventId(String instanceEventId) {
            this.instanceEventId = instanceEventId;
        }

        public final String getCodeAsString() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(EventCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public final Instant getNotBeforeDeadline() {
            return this.notBeforeDeadline;
        }

        @Override
        public final Builder notBeforeDeadline(Instant notBeforeDeadline) {
            this.notBeforeDeadline = notBeforeDeadline;
            return this;
        }

        public final void setNotBeforeDeadline(Instant notBeforeDeadline) {
            this.notBeforeDeadline = notBeforeDeadline;
        }

        public InstanceStatusEvent build() {
            return new InstanceStatusEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStatusEvent> {
        public Builder instanceEventId(String var1);

        public Builder code(String var1);

        public Builder code(EventCode var1);

        public Builder description(String var1);

        public Builder notAfter(Instant var1);

        public Builder notBefore(Instant var1);

        public Builder notBeforeDeadline(Instant var1);
    }
}

