/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetail;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDetail> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceDetail.getter(ServiceDetail::serviceName)).setter(ServiceDetail.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("serviceName").build()}).build();
    private static final SdkField<List<ServiceTypeDetail>> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceDetail.getter(ServiceDetail::serviceType)).setter(ServiceDetail.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").unmarshallLocationName("serviceType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceTypeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceDetail.getter(ServiceDetail::availabilityZones)).setter(ServiceDetail.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet").unmarshallLocationName("availabilityZoneSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceDetail.getter(ServiceDetail::owner)).setter(ServiceDetail.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("owner").build()}).build();
    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceDetail.getter(ServiceDetail::baseEndpointDnsNames)).setter(ServiceDetail.setter(Builder::baseEndpointDnsNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNameSet").unmarshallLocationName("baseEndpointDnsNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceDetail.getter(ServiceDetail::privateDnsName)).setter(ServiceDetail.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<Boolean> VPC_ENDPOINT_POLICY_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ServiceDetail.getter(ServiceDetail::vpcEndpointPolicySupported)).setter(ServiceDetail.setter(Builder::vpcEndpointPolicySupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointPolicySupported").unmarshallLocationName("vpcEndpointPolicySupported").build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ServiceDetail.getter(ServiceDetail::acceptanceRequired)).setter(ServiceDetail.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("acceptanceRequired").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, SERVICE_TYPE_FIELD, AVAILABILITY_ZONES_FIELD, OWNER_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD, PRIVATE_DNS_NAME_FIELD, VPC_ENDPOINT_POLICY_SUPPORTED_FIELD, ACCEPTANCE_REQUIRED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final List<ServiceTypeDetail> serviceType;
    private final List<String> availabilityZones;
    private final String owner;
    private final List<String> baseEndpointDnsNames;
    private final String privateDnsName;
    private final Boolean vpcEndpointPolicySupported;
    private final Boolean acceptanceRequired;

    private ServiceDetail(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceType = builder.serviceType;
        this.availabilityZones = builder.availabilityZones;
        this.owner = builder.owner;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.vpcEndpointPolicySupported = builder.vpcEndpointPolicySupported;
        this.acceptanceRequired = builder.acceptanceRequired;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public List<ServiceTypeDetail> serviceType() {
        return this.serviceType;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String owner() {
        return this.owner;
    }

    public List<String> baseEndpointDnsNames() {
        return this.baseEndpointDnsNames;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public Boolean vpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpointDnsNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointPolicySupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDetail)) {
            return false;
        }
        ServiceDetail other = (ServiceDetail)obj;
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceType(), other.serviceType()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.baseEndpointDnsNames(), other.baseEndpointDnsNames()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.vpcEndpointPolicySupported(), other.vpcEndpointPolicySupported()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired());
    }

    public String toString() {
        return ToString.builder((String)"ServiceDetail").add("ServiceName", (Object)this.serviceName()).add("ServiceType", this.serviceType()).add("AvailabilityZones", this.availabilityZones()).add("Owner", (Object)this.owner()).add("BaseEndpointDnsNames", this.baseEndpointDnsNames()).add("PrivateDnsName", (Object)this.privateDnsName()).add("VpcEndpointPolicySupported", (Object)this.vpcEndpointPolicySupported()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceType()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "BaseEndpointDnsNames": {
                return Optional.ofNullable(clazz.cast(this.baseEndpointDnsNames()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "VpcEndpointPolicySupported": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointPolicySupported()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceDetail, T> g) {
        return obj -> g.apply((ServiceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private List<ServiceTypeDetail> serviceType = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String owner;
        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();
        private String privateDnsName;
        private Boolean vpcEndpointPolicySupported;
        private Boolean acceptanceRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDetail model) {
            this.serviceName(model.serviceName);
            this.serviceType(model.serviceType);
            this.availabilityZones(model.availabilityZones);
            this.owner(model.owner);
            this.baseEndpointDnsNames(model.baseEndpointDnsNames);
            this.privateDnsName(model.privateDnsName);
            this.vpcEndpointPolicySupported(model.vpcEndpointPolicySupported);
            this.acceptanceRequired(model.acceptanceRequired);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final Collection<ServiceTypeDetail.Builder> getServiceType() {
            return this.serviceType != null ? (Collection)this.serviceType.stream().map(ServiceTypeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail ... serviceType) {
            this.serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... serviceType) {
            this.serviceType(Stream.of(serviceType).map(c -> (ServiceTypeDetail)((ServiceTypeDetail.Builder)ServiceTypeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            return this.baseEndpointDnsNames;
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String ... baseEndpointDnsNames) {
            this.baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final Boolean getVpcEndpointPolicySupported() {
            return this.vpcEndpointPolicySupported;
        }

        @Override
        public final Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
            return this;
        }

        public final void setVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public ServiceDetail build() {
            return new ServiceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDetail> {
        public Builder serviceName(String var1);

        public Builder serviceType(Collection<ServiceTypeDetail> var1);

        public Builder serviceType(ServiceTypeDetail ... var1);

        public Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder owner(String var1);

        public Builder baseEndpointDnsNames(Collection<String> var1);

        public Builder baseEndpointDnsNames(String ... var1);

        public Builder privateDnsName(String var1);

        public Builder vpcEndpointPolicySupported(Boolean var1);

        public Builder acceptanceRequired(Boolean var1);
    }
}

