/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PeeringConnectionOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcPeeringConnectionOptionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsResponse> {
    private static final SdkField<PeeringConnectionOptions> ACCEPTER_PEERING_CONNECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyVpcPeeringConnectionOptionsResponse.getter(ModifyVpcPeeringConnectionOptionsResponse::accepterPeeringConnectionOptions)).setter(ModifyVpcPeeringConnectionOptionsResponse.setter(Builder::accepterPeeringConnectionOptions)).constructor(PeeringConnectionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterPeeringConnectionOptions").unmarshallLocationName("accepterPeeringConnectionOptions").build()}).build();
    private static final SdkField<PeeringConnectionOptions> REQUESTER_PEERING_CONNECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyVpcPeeringConnectionOptionsResponse.getter(ModifyVpcPeeringConnectionOptionsResponse::requesterPeeringConnectionOptions)).setter(ModifyVpcPeeringConnectionOptionsResponse.setter(Builder::requesterPeeringConnectionOptions)).constructor(PeeringConnectionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPeeringConnectionOptions").unmarshallLocationName("requesterPeeringConnectionOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTER_PEERING_CONNECTION_OPTIONS_FIELD, REQUESTER_PEERING_CONNECTION_OPTIONS_FIELD));
    private final PeeringConnectionOptions accepterPeeringConnectionOptions;
    private final PeeringConnectionOptions requesterPeeringConnectionOptions;

    private ModifyVpcPeeringConnectionOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.accepterPeeringConnectionOptions = builder.accepterPeeringConnectionOptions;
        this.requesterPeeringConnectionOptions = builder.requesterPeeringConnectionOptions;
    }

    public PeeringConnectionOptions accepterPeeringConnectionOptions() {
        return this.accepterPeeringConnectionOptions;
    }

    public PeeringConnectionOptions requesterPeeringConnectionOptions() {
        return this.requesterPeeringConnectionOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accepterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPeeringConnectionOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcPeeringConnectionOptionsResponse)) {
            return false;
        }
        ModifyVpcPeeringConnectionOptionsResponse other = (ModifyVpcPeeringConnectionOptionsResponse)((Object)obj);
        return Objects.equals(this.accepterPeeringConnectionOptions(), other.accepterPeeringConnectionOptions()) && Objects.equals(this.requesterPeeringConnectionOptions(), other.requesterPeeringConnectionOptions());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcPeeringConnectionOptionsResponse").add("AccepterPeeringConnectionOptions", (Object)this.accepterPeeringConnectionOptions()).add("RequesterPeeringConnectionOptions", (Object)this.requesterPeeringConnectionOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccepterPeeringConnectionOptions": {
                return Optional.ofNullable(clazz.cast(this.accepterPeeringConnectionOptions()));
            }
            case "RequesterPeeringConnectionOptions": {
                return Optional.ofNullable(clazz.cast(this.requesterPeeringConnectionOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcPeeringConnectionOptionsResponse, T> g) {
        return obj -> g.apply((ModifyVpcPeeringConnectionOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private PeeringConnectionOptions accepterPeeringConnectionOptions;
        private PeeringConnectionOptions requesterPeeringConnectionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcPeeringConnectionOptionsResponse model) {
            super(model);
            this.accepterPeeringConnectionOptions(model.accepterPeeringConnectionOptions);
            this.requesterPeeringConnectionOptions(model.requesterPeeringConnectionOptions);
        }

        public final PeeringConnectionOptions.Builder getAccepterPeeringConnectionOptions() {
            return this.accepterPeeringConnectionOptions != null ? this.accepterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder accepterPeeringConnectionOptions(PeeringConnectionOptions accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
            return this;
        }

        public final void setAccepterPeeringConnectionOptions(PeeringConnectionOptions.BuilderImpl accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions.build() : null;
        }

        public final PeeringConnectionOptions.Builder getRequesterPeeringConnectionOptions() {
            return this.requesterPeeringConnectionOptions != null ? this.requesterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder requesterPeeringConnectionOptions(PeeringConnectionOptions requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
            return this;
        }

        public final void setRequesterPeeringConnectionOptions(PeeringConnectionOptions.BuilderImpl requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions.build() : null;
        }

        @Override
        public ModifyVpcPeeringConnectionOptionsResponse build() {
            return new ModifyVpcPeeringConnectionOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsResponse> {
        public Builder accepterPeeringConnectionOptions(PeeringConnectionOptions var1);

        default public Builder accepterPeeringConnectionOptions(Consumer<PeeringConnectionOptions.Builder> accepterPeeringConnectionOptions) {
            return this.accepterPeeringConnectionOptions((PeeringConnectionOptions)((PeeringConnectionOptions.Builder)PeeringConnectionOptions.builder().applyMutation(accepterPeeringConnectionOptions)).build());
        }

        public Builder requesterPeeringConnectionOptions(PeeringConnectionOptions var1);

        default public Builder requesterPeeringConnectionOptions(Consumer<PeeringConnectionOptions.Builder> requesterPeeringConnectionOptions) {
            return this.requesterPeeringConnectionOptions((PeeringConnectionOptions)((PeeringConnectionOptions.Builder)PeeringConnectionOptions.builder().applyMutation(requesterPeeringConnectionOptions)).build());
        }
    }
}

