/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.FleetData;

public class DescribeFleetsPublisher
implements SdkPublisher<DescribeFleetsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFleetsPublisher(Ec2AsyncClient client, DescribeFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFleetsPublisher(Ec2AsyncClient client, DescribeFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetData> fleets() {
        return this.flatMapIterable(response -> response.fleets());
    }

    private class DescribeFleetsResponseFetcher
    implements AsyncPageFetcher<DescribeFleetsResponse> {
        private DescribeFleetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFleetsResponse> nextPage(DescribeFleetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetsPublisher.this.client.describeFleets(DescribeFleetsPublisher.this.firstRequest);
            }
            return DescribeFleetsPublisher.this.client.describeFleets((DescribeFleetsRequest)((Object)DescribeFleetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

