/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.RouteTable;

public class DescribeRouteTablesPublisher
implements SdkPublisher<DescribeRouteTablesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeRouteTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRouteTablesPublisher(Ec2AsyncClient client, DescribeRouteTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRouteTablesPublisher(Ec2AsyncClient client, DescribeRouteTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRouteTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRouteTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RouteTable> routeTables() {
        return this.flatMapIterable(response -> response.routeTables());
    }

    private class DescribeRouteTablesResponseFetcher
    implements AsyncPageFetcher<DescribeRouteTablesResponse> {
        private DescribeRouteTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRouteTablesResponse> nextPage(DescribeRouteTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteTablesPublisher.this.client.describeRouteTables(DescribeRouteTablesPublisher.this.firstRequest);
            }
            return DescribeRouteTablesPublisher.this.client.describeRouteTables((DescribeRouteTablesRequest)((Object)DescribeRouteTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

