/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryNetworksResponse;
import software.amazon.awssdk.services.ec2.model.SecondaryNetwork;

public class DescribeSecondaryNetworksIterable
implements SdkIterable<DescribeSecondaryNetworksResponse> {
    private final Ec2Client client;
    private final DescribeSecondaryNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSecondaryNetworksIterable(Ec2Client client, DescribeSecondaryNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSecondaryNetworksResponseFetcher();
    }

    public Iterator<DescribeSecondaryNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecondaryNetwork> secondaryNetworks() {
        Function<DescribeSecondaryNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.secondaryNetworks() != null) {
                return response.secondaryNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSecondaryNetworksResponseFetcher
    implements SyncPageFetcher<DescribeSecondaryNetworksResponse> {
        private DescribeSecondaryNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecondaryNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSecondaryNetworksResponse nextPage(DescribeSecondaryNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecondaryNetworksIterable.this.client.describeSecondaryNetworks(DescribeSecondaryNetworksIterable.this.firstRequest);
            }
            return DescribeSecondaryNetworksIterable.this.client.describeSecondaryNetworks((DescribeSecondaryNetworksRequest)((Object)DescribeSecondaryNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

