/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.OperatorResponse;
import software.amazon.awssdk.services.ec2.model.VolumeState;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeRecycleBinInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeRecycleBinInfo> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::volumeId)).setter(VolumeRecycleBinInfo.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::volumeTypeAsString)).setter(VolumeRecycleBinInfo.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").unmarshallLocationName("volumeType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::stateAsString)).setter(VolumeRecycleBinInfo.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::size)).setter(VolumeRecycleBinInfo.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").unmarshallLocationName("size").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::iops)).setter(VolumeRecycleBinInfo.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").unmarshallLocationName("iops").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Throughput").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::throughput)).setter(VolumeRecycleBinInfo.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").unmarshallLocationName("throughput").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::outpostArn)).setter(VolumeRecycleBinInfo.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::availabilityZone)).setter(VolumeRecycleBinInfo.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::availabilityZoneId)).setter(VolumeRecycleBinInfo.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> SOURCE_VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceVolumeId").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::sourceVolumeId)).setter(VolumeRecycleBinInfo.setter(Builder::sourceVolumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVolumeId").unmarshallLocationName("sourceVolumeId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::snapshotId)).setter(VolumeRecycleBinInfo.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::operator)).setter(VolumeRecycleBinInfo.setter(Builder::operator)).constructor(OperatorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("operator").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::createTime)).setter(VolumeRecycleBinInfo.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<Instant> RECYCLE_BIN_ENTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecycleBinEnterTime").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::recycleBinEnterTime)).setter(VolumeRecycleBinInfo.setter(Builder::recycleBinEnterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinEnterTime").unmarshallLocationName("recycleBinEnterTime").build()}).build();
    private static final SdkField<Instant> RECYCLE_BIN_EXIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecycleBinExitTime").getter(VolumeRecycleBinInfo.getter(VolumeRecycleBinInfo::recycleBinExitTime)).setter(VolumeRecycleBinInfo.setter(Builder::recycleBinExitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinExitTime").unmarshallLocationName("recycleBinExitTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD, VOLUME_TYPE_FIELD, STATE_FIELD, SIZE_FIELD, IOPS_FIELD, THROUGHPUT_FIELD, OUTPOST_ARN_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, SOURCE_VOLUME_ID_FIELD, SNAPSHOT_ID_FIELD, OPERATOR_FIELD, CREATE_TIME_FIELD, RECYCLE_BIN_ENTER_TIME_FIELD, RECYCLE_BIN_EXIT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VolumeRecycleBinInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String volumeId;
    private final String volumeType;
    private final String state;
    private final Integer size;
    private final Integer iops;
    private final Integer throughput;
    private final String outpostArn;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final String sourceVolumeId;
    private final String snapshotId;
    private final OperatorResponse operator;
    private final Instant createTime;
    private final Instant recycleBinEnterTime;
    private final Instant recycleBinExitTime;

    private VolumeRecycleBinInfo(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.volumeType = builder.volumeType;
        this.state = builder.state;
        this.size = builder.size;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.outpostArn = builder.outpostArn;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.sourceVolumeId = builder.sourceVolumeId;
        this.snapshotId = builder.snapshotId;
        this.operator = builder.operator;
        this.createTime = builder.createTime;
        this.recycleBinEnterTime = builder.recycleBinEnterTime;
        this.recycleBinExitTime = builder.recycleBinExitTime;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final VolumeState state() {
        return VolumeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer size() {
        return this.size;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String sourceVolumeId() {
        return this.sourceVolumeId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final OperatorResponse operator() {
        return this.operator;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant recycleBinEnterTime() {
        return this.recycleBinEnterTime;
    }

    public final Instant recycleBinExitTime() {
        return this.recycleBinExitTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinEnterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinExitTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecycleBinInfo)) {
            return false;
        }
        VolumeRecycleBinInfo other = (VolumeRecycleBinInfo)obj;
        return Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.throughput(), other.throughput()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.sourceVolumeId(), other.sourceVolumeId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.operator(), other.operator()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.recycleBinEnterTime(), other.recycleBinEnterTime()) && Objects.equals(this.recycleBinExitTime(), other.recycleBinExitTime());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeRecycleBinInfo").add("VolumeId", (Object)this.volumeId()).add("VolumeType", (Object)this.volumeTypeAsString()).add("State", (Object)this.stateAsString()).add("Size", (Object)this.size()).add("Iops", (Object)this.iops()).add("Throughput", (Object)this.throughput()).add("OutpostArn", (Object)this.outpostArn()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("SourceVolumeId", (Object)this.sourceVolumeId()).add("SnapshotId", (Object)this.snapshotId()).add("Operator", (Object)this.operator()).add("CreateTime", (Object)this.createTime()).add("RecycleBinEnterTime", (Object)this.recycleBinEnterTime()).add("RecycleBinExitTime", (Object)this.recycleBinExitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "SourceVolumeId": {
                return Optional.ofNullable(clazz.cast(this.sourceVolumeId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "RecycleBinEnterTime": {
                return Optional.ofNullable(clazz.cast(this.recycleBinEnterTime()));
            }
            case "RecycleBinExitTime": {
                return Optional.ofNullable(clazz.cast(this.recycleBinExitTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("SourceVolumeId", SOURCE_VOLUME_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("RecycleBinEnterTime", RECYCLE_BIN_ENTER_TIME_FIELD);
        map.put("RecycleBinExitTime", RECYCLE_BIN_EXIT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecycleBinInfo, T> g) {
        return obj -> g.apply((VolumeRecycleBinInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeId;
        private String volumeType;
        private String state;
        private Integer size;
        private Integer iops;
        private Integer throughput;
        private String outpostArn;
        private String availabilityZone;
        private String availabilityZoneId;
        private String sourceVolumeId;
        private String snapshotId;
        private OperatorResponse operator;
        private Instant createTime;
        private Instant recycleBinEnterTime;
        private Instant recycleBinExitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecycleBinInfo model) {
            this.volumeId(model.volumeId);
            this.volumeType(model.volumeType);
            this.state(model.state);
            this.size(model.size);
            this.iops(model.iops);
            this.throughput(model.throughput);
            this.outpostArn(model.outpostArn);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.sourceVolumeId(model.sourceVolumeId);
            this.snapshotId(model.snapshotId);
            this.operator(model.operator);
            this.createTime(model.createTime);
            this.recycleBinEnterTime(model.recycleBinEnterTime);
            this.recycleBinExitTime(model.recycleBinExitTime);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getSize() {
            return this.size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getSourceVolumeId() {
            return this.sourceVolumeId;
        }

        public final void setSourceVolumeId(String sourceVolumeId) {
            this.sourceVolumeId = sourceVolumeId;
        }

        @Override
        public final Builder sourceVolumeId(String sourceVolumeId) {
            this.sourceVolumeId = sourceVolumeId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getRecycleBinEnterTime() {
            return this.recycleBinEnterTime;
        }

        public final void setRecycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
        }

        @Override
        public final Builder recycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
            return this;
        }

        public final Instant getRecycleBinExitTime() {
            return this.recycleBinExitTime;
        }

        public final void setRecycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
        }

        @Override
        public final Builder recycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
            return this;
        }

        public VolumeRecycleBinInfo build() {
            return new VolumeRecycleBinInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeRecycleBinInfo> {
        public Builder volumeId(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder state(String var1);

        public Builder state(VolumeState var1);

        public Builder size(Integer var1);

        public Builder iops(Integer var1);

        public Builder throughput(Integer var1);

        public Builder outpostArn(String var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder sourceVolumeId(String var1);

        public Builder snapshotId(String var1);

        public Builder operator(OperatorResponse var1);

        default public Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return this.operator((OperatorResponse)((OperatorResponse.Builder)OperatorResponse.builder().applyMutation(operator)).build());
        }

        public Builder createTime(Instant var1);

        public Builder recycleBinEnterTime(Instant var1);

        public Builder recycleBinExitTime(Instant var1);
    }
}

