/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecondarySubnet;
import software.amazon.awssdk.services.ec2.model.SecondarySubnetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSecondarySubnetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSecondarySubnetsResponse> {
    private static final SdkField<List<SecondarySubnet>> SECONDARY_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecondarySubnets").getter(DescribeSecondarySubnetsResponse.getter(DescribeSecondarySubnetsResponse::secondarySubnets)).setter(DescribeSecondarySubnetsResponse.setter(Builder::secondarySubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetSet").unmarshallLocationName("secondarySubnetSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondarySubnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSecondarySubnetsResponse.getter(DescribeSecondarySubnetsResponse::nextToken)).setter(DescribeSecondarySubnetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_SUBNETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSecondarySubnetsResponse.memberNameToFieldInitializer();
    private final List<SecondarySubnet> secondarySubnets;
    private final String nextToken;

    private DescribeSecondarySubnetsResponse(BuilderImpl builder) {
        super(builder);
        this.secondarySubnets = builder.secondarySubnets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecondarySubnets() {
        return this.secondarySubnets != null && !(this.secondarySubnets instanceof SdkAutoConstructList);
    }

    public final List<SecondarySubnet> secondarySubnets() {
        return this.secondarySubnets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySubnets() ? this.secondarySubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecondarySubnetsResponse)) {
            return false;
        }
        DescribeSecondarySubnetsResponse other = (DescribeSecondarySubnetsResponse)((Object)obj);
        return this.hasSecondarySubnets() == other.hasSecondarySubnets() && Objects.equals(this.secondarySubnets(), other.secondarySubnets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSecondarySubnetsResponse").add("SecondarySubnets", this.hasSecondarySubnets() ? this.secondarySubnets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecondarySubnets": {
                return Optional.ofNullable(clazz.cast(this.secondarySubnets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecondarySubnetSet", SECONDARY_SUBNETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecondarySubnetsResponse, T> g) {
        return obj -> g.apply((DescribeSecondarySubnetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SecondarySubnet> secondarySubnets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecondarySubnetsResponse model) {
            super(model);
            this.secondarySubnets(model.secondarySubnets);
            this.nextToken(model.nextToken);
        }

        public final List<SecondarySubnet.Builder> getSecondarySubnets() {
            List<SecondarySubnet.Builder> result = SecondarySubnetListCopier.copyToBuilder(this.secondarySubnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySubnets(Collection<SecondarySubnet.BuilderImpl> secondarySubnets) {
            this.secondarySubnets = SecondarySubnetListCopier.copyFromBuilder(secondarySubnets);
        }

        @Override
        public final Builder secondarySubnets(Collection<SecondarySubnet> secondarySubnets) {
            this.secondarySubnets = SecondarySubnetListCopier.copy(secondarySubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySubnets(SecondarySubnet ... secondarySubnets) {
            this.secondarySubnets(Arrays.asList(secondarySubnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySubnets(Consumer<SecondarySubnet.Builder> ... secondarySubnets) {
            this.secondarySubnets(Stream.of(secondarySubnets).map(c -> (SecondarySubnet)((SecondarySubnet.Builder)SecondarySubnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSecondarySubnetsResponse build() {
            return new DescribeSecondarySubnetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSecondarySubnetsResponse> {
        public Builder secondarySubnets(Collection<SecondarySubnet> var1);

        public Builder secondarySubnets(SecondarySubnet ... var1);

        public Builder secondarySubnets(Consumer<SecondarySubnet.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

