/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDataExportResponse;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDataExportResponseSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityManagerDataExportsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityManagerDataExportsResponse> {
    private static final SdkField<List<CapacityManagerDataExportResponse>> CAPACITY_MANAGER_DATA_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityManagerDataExports").getter(DescribeCapacityManagerDataExportsResponse.getter(DescribeCapacityManagerDataExportsResponse::capacityManagerDataExports)).setter(DescribeCapacityManagerDataExportsResponse.setter(Builder::capacityManagerDataExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerDataExportSet").unmarshallLocationName("capacityManagerDataExportSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityManagerDataExportResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityManagerDataExportsResponse.getter(DescribeCapacityManagerDataExportsResponse::nextToken)).setter(DescribeCapacityManagerDataExportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_MANAGER_DATA_EXPORTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityManagerDataExportsResponse.memberNameToFieldInitializer();
    private final List<CapacityManagerDataExportResponse> capacityManagerDataExports;
    private final String nextToken;

    private DescribeCapacityManagerDataExportsResponse(BuilderImpl builder) {
        super(builder);
        this.capacityManagerDataExports = builder.capacityManagerDataExports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityManagerDataExports() {
        return this.capacityManagerDataExports != null && !(this.capacityManagerDataExports instanceof SdkAutoConstructList);
    }

    public final List<CapacityManagerDataExportResponse> capacityManagerDataExports() {
        return this.capacityManagerDataExports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityManagerDataExports() ? this.capacityManagerDataExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityManagerDataExportsResponse)) {
            return false;
        }
        DescribeCapacityManagerDataExportsResponse other = (DescribeCapacityManagerDataExportsResponse)((Object)obj);
        return this.hasCapacityManagerDataExports() == other.hasCapacityManagerDataExports() && Objects.equals(this.capacityManagerDataExports(), other.capacityManagerDataExports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityManagerDataExportsResponse").add("CapacityManagerDataExports", this.hasCapacityManagerDataExports() ? this.capacityManagerDataExports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityManagerDataExports": {
                return Optional.ofNullable(clazz.cast(this.capacityManagerDataExports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityManagerDataExportSet", CAPACITY_MANAGER_DATA_EXPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityManagerDataExportsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityManagerDataExportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityManagerDataExportResponse> capacityManagerDataExports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityManagerDataExportsResponse model) {
            super(model);
            this.capacityManagerDataExports(model.capacityManagerDataExports);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityManagerDataExportResponse.Builder> getCapacityManagerDataExports() {
            List<CapacityManagerDataExportResponse.Builder> result = CapacityManagerDataExportResponseSetCopier.copyToBuilder(this.capacityManagerDataExports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityManagerDataExports(Collection<CapacityManagerDataExportResponse.BuilderImpl> capacityManagerDataExports) {
            this.capacityManagerDataExports = CapacityManagerDataExportResponseSetCopier.copyFromBuilder(capacityManagerDataExports);
        }

        @Override
        public final Builder capacityManagerDataExports(Collection<CapacityManagerDataExportResponse> capacityManagerDataExports) {
            this.capacityManagerDataExports = CapacityManagerDataExportResponseSetCopier.copy(capacityManagerDataExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityManagerDataExports(CapacityManagerDataExportResponse ... capacityManagerDataExports) {
            this.capacityManagerDataExports(Arrays.asList(capacityManagerDataExports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityManagerDataExports(Consumer<CapacityManagerDataExportResponse.Builder> ... capacityManagerDataExports) {
            this.capacityManagerDataExports(Stream.of(capacityManagerDataExports).map(c -> (CapacityManagerDataExportResponse)((CapacityManagerDataExportResponse.Builder)CapacityManagerDataExportResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityManagerDataExportsResponse build() {
            return new DescribeCapacityManagerDataExportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityManagerDataExportsResponse> {
        public Builder capacityManagerDataExports(Collection<CapacityManagerDataExportResponse> var1);

        public Builder capacityManagerDataExports(CapacityManagerDataExportResponse ... var1);

        public Builder capacityManagerDataExports(Consumer<CapacityManagerDataExportResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

