/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryNetworksResponse;
import software.amazon.awssdk.services.ec2.model.SecondaryNetwork;

public class DescribeSecondaryNetworksPublisher
implements SdkPublisher<DescribeSecondaryNetworksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSecondaryNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSecondaryNetworksPublisher(Ec2AsyncClient client, DescribeSecondaryNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSecondaryNetworksPublisher(Ec2AsyncClient client, DescribeSecondaryNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSecondaryNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSecondaryNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecondaryNetwork> secondaryNetworks() {
        return this.flatMapIterable(response -> response.secondaryNetworks());
    }

    private class DescribeSecondaryNetworksResponseFetcher
    implements AsyncPageFetcher<DescribeSecondaryNetworksResponse> {
        private DescribeSecondaryNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecondaryNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSecondaryNetworksResponse> nextPage(DescribeSecondaryNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecondaryNetworksPublisher.this.client.describeSecondaryNetworks(DescribeSecondaryNetworksPublisher.this.firstRequest);
            }
            return DescribeSecondaryNetworksPublisher.this.client.describeSecondaryNetworks((DescribeSecondaryNetworksRequest)((Object)DescribeSecondaryNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

