/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SecondaryNetworkIpv4CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.SecondaryNetworkIpv4CidrBlockAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.SecondaryNetworkState;
import software.amazon.awssdk.services.ec2.model.SecondaryNetworkType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecondaryNetwork
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecondaryNetwork> {
    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkId").getter(SecondaryNetwork.getter(SecondaryNetwork::secondaryNetworkId)).setter(SecondaryNetwork.setter(Builder::secondaryNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId").unmarshallLocationName("secondaryNetworkId").build()}).build();
    private static final SdkField<String> SECONDARY_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkArn").getter(SecondaryNetwork.getter(SecondaryNetwork::secondaryNetworkArn)).setter(SecondaryNetwork.setter(Builder::secondaryNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkArn").unmarshallLocationName("secondaryNetworkArn").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SecondaryNetwork.getter(SecondaryNetwork::ownerId)).setter(SecondaryNetwork.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SecondaryNetwork.getter(SecondaryNetwork::typeAsString)).setter(SecondaryNetwork.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SecondaryNetwork.getter(SecondaryNetwork::stateAsString)).setter(SecondaryNetwork.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(SecondaryNetwork.getter(SecondaryNetwork::stateReason)).setter(SecondaryNetwork.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").unmarshallLocationName("stateReason").build()}).build();
    private static final SdkField<List<SecondaryNetworkIpv4CidrBlockAssociation>> IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4CidrBlockAssociations").getter(SecondaryNetwork.getter(SecondaryNetwork::ipv4CidrBlockAssociations)).setter(SecondaryNetwork.setter(Builder::ipv4CidrBlockAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4CidrBlockAssociationSet").unmarshallLocationName("ipv4CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondaryNetworkIpv4CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SecondaryNetwork.getter(SecondaryNetwork::tags)).setter(SecondaryNetwork.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_NETWORK_ID_FIELD, SECONDARY_NETWORK_ARN_FIELD, OWNER_ID_FIELD, TYPE_FIELD, STATE_FIELD, STATE_REASON_FIELD, IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecondaryNetwork.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String secondaryNetworkId;
    private final String secondaryNetworkArn;
    private final String ownerId;
    private final String type;
    private final String state;
    private final String stateReason;
    private final List<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations;
    private final List<Tag> tags;

    private SecondaryNetwork(BuilderImpl builder) {
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.secondaryNetworkArn = builder.secondaryNetworkArn;
        this.ownerId = builder.ownerId;
        this.type = builder.type;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.ipv4CidrBlockAssociations = builder.ipv4CidrBlockAssociations;
        this.tags = builder.tags;
    }

    public final String secondaryNetworkId() {
        return this.secondaryNetworkId;
    }

    public final String secondaryNetworkArn() {
        return this.secondaryNetworkArn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final SecondaryNetworkType type() {
        return SecondaryNetworkType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final SecondaryNetworkState state() {
        return SecondaryNetworkState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final boolean hasIpv4CidrBlockAssociations() {
        return this.ipv4CidrBlockAssociations != null && !(this.ipv4CidrBlockAssociations instanceof SdkAutoConstructList);
    }

    public final List<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations() {
        return this.ipv4CidrBlockAssociations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4CidrBlockAssociations() ? this.ipv4CidrBlockAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryNetwork)) {
            return false;
        }
        SecondaryNetwork other = (SecondaryNetwork)obj;
        return Objects.equals(this.secondaryNetworkId(), other.secondaryNetworkId()) && Objects.equals(this.secondaryNetworkArn(), other.secondaryNetworkArn()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && this.hasIpv4CidrBlockAssociations() == other.hasIpv4CidrBlockAssociations() && Objects.equals(this.ipv4CidrBlockAssociations(), other.ipv4CidrBlockAssociations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SecondaryNetwork").add("SecondaryNetworkId", (Object)this.secondaryNetworkId()).add("SecondaryNetworkArn", (Object)this.secondaryNetworkArn()).add("OwnerId", (Object)this.ownerId()).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("Ipv4CidrBlockAssociations", this.hasIpv4CidrBlockAssociations() ? this.ipv4CidrBlockAssociations() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecondaryNetworkId": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkId()));
            }
            case "SecondaryNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkArn()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "Ipv4CidrBlockAssociations": {
                return Optional.ofNullable(clazz.cast(this.ipv4CidrBlockAssociations()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("SecondaryNetworkArn", SECONDARY_NETWORK_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("Ipv4CidrBlockAssociationSet", IPV4_CIDR_BLOCK_ASSOCIATIONS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryNetwork, T> g) {
        return obj -> g.apply((SecondaryNetwork)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secondaryNetworkId;
        private String secondaryNetworkArn;
        private String ownerId;
        private String type;
        private String state;
        private String stateReason;
        private List<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryNetwork model) {
            this.secondaryNetworkId(model.secondaryNetworkId);
            this.secondaryNetworkArn(model.secondaryNetworkArn);
            this.ownerId(model.ownerId);
            this.type(model.type);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.ipv4CidrBlockAssociations(model.ipv4CidrBlockAssociations);
            this.tags(model.tags);
        }

        public final String getSecondaryNetworkId() {
            return this.secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getSecondaryNetworkArn() {
            return this.secondaryNetworkArn;
        }

        public final void setSecondaryNetworkArn(String secondaryNetworkArn) {
            this.secondaryNetworkArn = secondaryNetworkArn;
        }

        @Override
        public final Builder secondaryNetworkArn(String secondaryNetworkArn) {
            this.secondaryNetworkArn = secondaryNetworkArn;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecondaryNetworkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecondaryNetworkState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<SecondaryNetworkIpv4CidrBlockAssociation.Builder> getIpv4CidrBlockAssociations() {
            List<SecondaryNetworkIpv4CidrBlockAssociation.Builder> result = SecondaryNetworkIpv4CidrBlockAssociationListCopier.copyToBuilder(this.ipv4CidrBlockAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4CidrBlockAssociations(Collection<SecondaryNetworkIpv4CidrBlockAssociation.BuilderImpl> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondaryNetworkIpv4CidrBlockAssociationListCopier.copyFromBuilder(ipv4CidrBlockAssociations);
        }

        @Override
        public final Builder ipv4CidrBlockAssociations(Collection<SecondaryNetworkIpv4CidrBlockAssociation> ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations = SecondaryNetworkIpv4CidrBlockAssociationListCopier.copy(ipv4CidrBlockAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(SecondaryNetworkIpv4CidrBlockAssociation ... ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations(Arrays.asList(ipv4CidrBlockAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4CidrBlockAssociations(Consumer<SecondaryNetworkIpv4CidrBlockAssociation.Builder> ... ipv4CidrBlockAssociations) {
            this.ipv4CidrBlockAssociations(Stream.of(ipv4CidrBlockAssociations).map(c -> (SecondaryNetworkIpv4CidrBlockAssociation)((SecondaryNetworkIpv4CidrBlockAssociation.Builder)SecondaryNetworkIpv4CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecondaryNetwork build() {
            return new SecondaryNetwork(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecondaryNetwork> {
        public Builder secondaryNetworkId(String var1);

        public Builder secondaryNetworkArn(String var1);

        public Builder ownerId(String var1);

        public Builder type(String var1);

        public Builder type(SecondaryNetworkType var1);

        public Builder state(String var1);

        public Builder state(SecondaryNetworkState var1);

        public Builder stateReason(String var1);

        public Builder ipv4CidrBlockAssociations(Collection<SecondaryNetworkIpv4CidrBlockAssociation> var1);

        public Builder ipv4CidrBlockAssociations(SecondaryNetworkIpv4CidrBlockAssociation ... var1);

        public Builder ipv4CidrBlockAssociations(Consumer<SecondaryNetworkIpv4CidrBlockAssociation.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

