/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfacePrivateIpAddressSpecificationListRequestCopier;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfacePrivateIpAddressSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest> {
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest::deleteOnTermination)).setter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("DeleteOnTermination").build()}).build();
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeviceIndex").getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest::deviceIndex)).setter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("DeviceIndex").build()}).build();
    private static final SdkField<List<SecondaryInterfacePrivateIpAddressSpecificationRequest>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest::privateIpAddresses)).setter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress").build(), ListTrait.builder().memberLocationName("SecondaryInterfacePrivateIpAddressSpecification").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondaryInterfacePrivateIpAddressSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfacePrivateIpAddressSpecification").unmarshallLocationName("SecondaryInterfacePrivateIpAddressSpecification").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PrivateIpAddressCount").getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest::privateIpAddressCount)).setter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.setter(Builder::privateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressCount").unmarshallLocationName("PrivateIpAddressCount").build()}).build();
    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondarySubnetId").getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest::secondarySubnetId)).setter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.setter(Builder::secondarySubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId").unmarshallLocationName("SecondarySubnetId").build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest::interfaceTypeAsString)).setter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("InterfaceType").build()}).build();
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.getter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest::networkCardIndex)).setter(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("NetworkCardIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_ON_TERMINATION_FIELD, DEVICE_INDEX_FIELD, PRIVATE_IP_ADDRESSES_FIELD, PRIVATE_IP_ADDRESS_COUNT_FIELD, SECONDARY_SUBNET_ID_FIELD, INTERFACE_TYPE_FIELD, NETWORK_CARD_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean deleteOnTermination;
    private final Integer deviceIndex;
    private final List<SecondaryInterfacePrivateIpAddressSpecificationRequest> privateIpAddresses;
    private final Integer privateIpAddressCount;
    private final String secondarySubnetId;
    private final String interfaceType;
    private final Integer networkCardIndex;

    private LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest(BuilderImpl builder) {
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.privateIpAddressCount = builder.privateIpAddressCount;
        this.secondarySubnetId = builder.secondarySubnetId;
        this.interfaceType = builder.interfaceType;
        this.networkCardIndex = builder.networkCardIndex;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final Integer deviceIndex() {
        return this.deviceIndex;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<SecondaryInterfacePrivateIpAddressSpecificationRequest> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Integer privateIpAddressCount() {
        return this.privateIpAddressCount;
    }

    public final String secondarySubnetId() {
        return this.secondarySubnetId;
    }

    public final SecondaryInterfaceType interfaceType() {
        return SecondaryInterfaceType.fromValue(this.interfaceType);
    }

    public final String interfaceTypeAsString() {
        return this.interfaceType;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest)) {
            return false;
        }
        LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest other = (LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest)obj;
        return Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.privateIpAddressCount(), other.privateIpAddressCount()) && Objects.equals(this.secondarySubnetId(), other.secondarySubnetId()) && Objects.equals(this.interfaceTypeAsString(), other.interfaceTypeAsString()) && Objects.equals(this.networkCardIndex(), other.networkCardIndex());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest").add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("DeviceIndex", (Object)this.deviceIndex()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("PrivateIpAddressCount", (Object)this.privateIpAddressCount()).add("SecondarySubnetId", (Object)this.secondarySubnetId()).add("InterfaceType", (Object)this.interfaceTypeAsString()).add("NetworkCardIndex", (Object)this.networkCardIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "PrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddressCount()));
            }
            case "SecondarySubnetId": {
                return Optional.ofNullable(clazz.cast(this.secondarySubnetId()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceTypeAsString()));
            }
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("DeviceIndex", DEVICE_INDEX_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("PrivateIpAddressCount", PRIVATE_IP_ADDRESS_COUNT_FIELD);
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("InterfaceType", INTERFACE_TYPE_FIELD);
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest, T> g) {
        return obj -> g.apply((LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean deleteOnTermination;
        private Integer deviceIndex;
        private List<SecondaryInterfacePrivateIpAddressSpecificationRequest> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer privateIpAddressCount;
        private String secondarySubnetId;
        private String interfaceType;
        private Integer networkCardIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest model) {
            this.deleteOnTermination(model.deleteOnTermination);
            this.deviceIndex(model.deviceIndex);
            this.privateIpAddresses(model.privateIpAddresses);
            this.privateIpAddressCount(model.privateIpAddressCount);
            this.secondarySubnetId(model.secondarySubnetId);
            this.interfaceType(model.interfaceType);
            this.networkCardIndex(model.networkCardIndex);
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final List<SecondaryInterfacePrivateIpAddressSpecificationRequest.Builder> getPrivateIpAddresses() {
            List<SecondaryInterfacePrivateIpAddressSpecificationRequest.Builder> result = SecondaryInterfacePrivateIpAddressSpecificationListRequestCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<SecondaryInterfacePrivateIpAddressSpecificationRequest.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = SecondaryInterfacePrivateIpAddressSpecificationListRequestCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<SecondaryInterfacePrivateIpAddressSpecificationRequest> privateIpAddresses) {
            this.privateIpAddresses = SecondaryInterfacePrivateIpAddressSpecificationListRequestCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(SecondaryInterfacePrivateIpAddressSpecificationRequest ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<SecondaryInterfacePrivateIpAddressSpecificationRequest.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (SecondaryInterfacePrivateIpAddressSpecificationRequest)((SecondaryInterfacePrivateIpAddressSpecificationRequest.Builder)SecondaryInterfacePrivateIpAddressSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPrivateIpAddressCount() {
            return this.privateIpAddressCount;
        }

        public final void setPrivateIpAddressCount(Integer privateIpAddressCount) {
            this.privateIpAddressCount = privateIpAddressCount;
        }

        @Override
        public final Builder privateIpAddressCount(Integer privateIpAddressCount) {
            this.privateIpAddressCount = privateIpAddressCount;
            return this;
        }

        public final String getSecondarySubnetId() {
            return this.secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(SecondaryInterfaceType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest build() {
            return new LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateInstanceSecondaryInterfaceSpecificationRequest> {
        public Builder deleteOnTermination(Boolean var1);

        public Builder deviceIndex(Integer var1);

        public Builder privateIpAddresses(Collection<SecondaryInterfacePrivateIpAddressSpecificationRequest> var1);

        public Builder privateIpAddresses(SecondaryInterfacePrivateIpAddressSpecificationRequest ... var1);

        public Builder privateIpAddresses(Consumer<SecondaryInterfacePrivateIpAddressSpecificationRequest.Builder> ... var1);

        public Builder privateIpAddressCount(Integer var1);

        public Builder secondarySubnetId(String var1);

        public Builder interfaceType(String var1);

        public Builder interfaceType(SecondaryInterfaceType var1);

        public Builder networkCardIndex(Integer var1);
    }
}

